"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentKeyCallOut = AgentKeyCallOut;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function AgentKeyCallOut({
  name,
  token
}) {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.apm.settings.agentKeys.copyAgentKeyField.title', {
      defaultMessage: 'Created "{name}" key',
      values: {
        name
      }
    }),
    color: "success",
    iconType: "check"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.apm.settings.agentKeys.copyAgentKeyField.message', {
    defaultMessage: 'Copy this key now. You will not be able to view it again.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "apmAgentKeyCallOutFieldText",
    readOnly: true,
    value: token,
    "aria-label": _i18n.i18n.translate('xpack.apm.settings.agentKeys.copyAgentKeyField.agentKeyLabel', {
      defaultMessage: 'APM agent key'
    }),
    prepend: "Base64",
    append: /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
      textToCopy: token
    }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": "apmAgentKeyCallOutButton",
      iconType: "copyClipboard",
      onClick: copy,
      color: "success",
      style: {
        backgroundColor: 'transparent'
      },
      "aria-label": _i18n.i18n.translate('xpack.apm.settings.agentKeys.copyAgentKeyField.copyButton', {
        defaultMessage: 'Copy to clipboard'
      })
    }))
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
}