"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentInstancesDetails = AgentInstancesDetails;
exports.getInstanceColumns = getInstanceColumns;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _metric_overview_link = require("../../../../../shared/links/apm/metric_overview_link");
var _agent_explorer = require("../../../../../../../common/agent_explorer");
var _agent_name = require("../../../../../../../common/agent_name");
var _service_nodes = require("../../../../../../../common/service_nodes");
var _style = require("../../../../../../utils/style");
var _environment_badge = require("../../../../../shared/environment_badge");
var _item_badge = require("../../../../../shared/item_badge");
var _popover_tooltip = require("../../../../../shared/popover_tooltip");
var _timestamp_tooltip = require("../../../../../shared/timestamp_tooltip");
var _truncate_with_tooltip = require("../../../../../shared/truncate_with_tooltip");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
var AgentExplorerInstanceFieldName = /*#__PURE__*/function (AgentExplorerInstanceFieldName) {
  AgentExplorerInstanceFieldName["InstanceName"] = "serviceNode";
  AgentExplorerInstanceFieldName["Environments"] = "environments";
  AgentExplorerInstanceFieldName["AgentVersion"] = "agentVersion";
  AgentExplorerInstanceFieldName["LastReport"] = "lastReport";
  return AgentExplorerInstanceFieldName;
}(AgentExplorerInstanceFieldName || {});
function getInstanceColumns(serviceName, agentName, agentDocsPageUrl) {
  return [{
    field: AgentExplorerInstanceFieldName.InstanceName,
    name: _i18n.i18n.translate('xpack.apm.agentExplorerInstanceTable.InstanceColumnLabel', {
      defaultMessage: 'Instance'
    }),
    sortable: true,
    render: (_, {
      serviceNode
    }) => {
      const displayedName = (0, _service_nodes.getServiceNodeName)(serviceNode);
      return serviceNode === _service_nodes.SERVICE_NODE_NAME_MISSING ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, displayedName, /*#__PURE__*/_react.default.createElement(_popover_tooltip.PopoverTooltip, {
        ariaLabel: _i18n.i18n.translate('xpack.apm.agentExplorerInstanceTable.noServiceNodeName.tooltip', {
          defaultMessage: 'Tooltip for missing serviceNodeName'
        })
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        style: {
          width: `${_style.unit * 24}px`
        },
        size: "s"
      }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        defaultMessage: "You can configure the service node name through {seeDocs}.",
        id: "xpack.apm.agentExplorerInstanceTable.noServiceNodeName.tooltip.linkToDocs",
        values: {
          seeDocs: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            "data-test-subj": "apmGetInstanceColumnsConfigurationOptionsLink",
            href: `${agentDocsPageUrl}${!(0, _agent_name.isOpenTelemetryAgentName)(agentName) ? 'configuration.html#service-node-name' : ''}`,
            target: "_blank"
          }, _i18n.i18n.translate('xpack.apm.agentExplorerInstanceTable.noServiceNodeName.configurationOptions', {
            defaultMessage: 'configuration options'
          }))
        }
      }))))) : /*#__PURE__*/_react.default.createElement(_truncate_with_tooltip.TruncateWithTooltip, {
        "data-test-subj": "apmAgentExplorerInstanceListServiceLink",
        text: displayedName,
        content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, serviceNode ? /*#__PURE__*/_react.default.createElement(_metric_overview_link.MetricOverviewLink, {
          serviceName: serviceName,
          mergeQuery: query => ({
            ...query,
            kuery: `service.node.name:"${displayedName}"`
          })
        }, displayedName) : /*#__PURE__*/_react.default.createElement("span", {
          className: "eui-textTruncate"
        }, displayedName))
      });
    }
  }, {
    field: AgentExplorerInstanceFieldName.Environments,
    name: _i18n.i18n.translate('xpack.apm.agentExplorerInstanceTable.environmentColumnLabel', {
      defaultMessage: 'Environment'
    }),
    width: `${_style.unit * 16}px`,
    sortable: true,
    render: (_, {
      environments
    }) => /*#__PURE__*/_react.default.createElement(_environment_badge.EnvironmentBadge, {
      environments: environments
    })
  }, {
    field: AgentExplorerInstanceFieldName.AgentVersion,
    name: _i18n.i18n.translate('xpack.apm.agentExplorerInstanceTable.agentVersionColumnLabel', {
      defaultMessage: 'Agent Version'
    }),
    width: `${_style.unit * 16}px`,
    sortable: true,
    render: (_, {
      agentVersion
    }) => {
      const versions = [agentVersion];
      return /*#__PURE__*/_react.default.createElement(_item_badge.ItemsBadge, {
        items: versions,
        multipleItemsMessage: _i18n.i18n.translate('xpack.apm.agentExplorerInstanceTable.agentVersionColumnLabel.multipleVersions', {
          values: {
            versionsCount: versions.length
          },
          defaultMessage: '{versionsCount, plural, one {1 version} other {# versions}}'
        })
      });
    }
  }, {
    field: AgentExplorerInstanceFieldName.LastReport,
    name: _i18n.i18n.translate('xpack.apm.agentExplorerInstanceTable.lastReportColumnLabel', {
      defaultMessage: 'Last report'
    }),
    width: `${_style.unit * 16}px`,
    sortable: true,
    render: (_, {
      lastReport
    }) => /*#__PURE__*/_react.default.createElement(_timestamp_tooltip.TimestampTooltip, {
      time: lastReport
    })
  }];
}
function AgentInstancesDetails({
  serviceName,
  agentName,
  agentDocsPageUrl,
  items,
  isLoading
}) {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    items: items,
    columns: getInstanceColumns(serviceName, agentName, agentDocsPageUrl),
    pagination: true,
    sorting: {
      sort: {
        field: _agent_explorer.AgentExplorerFieldName.AgentVersion,
        direction: 'desc'
      }
    },
    message: isLoading ? _i18n.i18n.translate('xpack.apm.agentInstanceDetails.table.loading', {
      defaultMessage: 'Loading...'
    }) : _i18n.i18n.translate('xpack.apm.agentInstanceDetails.table.noResults', {
      defaultMessage: 'No data found'
    })
  }));
}