"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/observability-plugin/common");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _observabilityAlertDetails = require("@kbn/observability-alert-details");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/data-plugin/public");
var _latency_chart = require("../../../shared/charts/latency_chart");
var _timeseries_chart = require("../../../shared/charts/timeseries_chart");
var _helper = require("../../../shared/charts/transaction_charts/helper");
var _get_comparison_options = require("../../../shared/time_comparison/get_comparison_options");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _latency_chart_selectors = require("../../../../selectors/latency_chart_selectors");
var _latency_aggregation_types = require("../../../../../common/latency_aggregation_types");
var _helpers = require("./helpers");
var _document_type = require("../../../../../common/document_type");
var _use_preferred_data_source_and_bucket_size = require("../../../../hooks/use_preferred_data_source_and_bucket_size");
var _constants = require("./constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function LatencyChart({
  alert,
  transactionType,
  transactionName,
  serviceName,
  environment,
  start,
  end,
  latencyAggregationType,
  comparisonChartTheme,
  comparisonEnabled,
  offset,
  timeZone
}) {
  const preferred = (0, _use_preferred_data_source_and_bucket_size.usePreferredDataSourceAndBucketSize)({
    start,
    end,
    kuery: '',
    numBuckets: 100,
    type: transactionName ? _document_type.ApmDocumentType.TransactionMetric : _document_type.ApmDocumentType.ServiceTransactionMetric
  });
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    services: {
      uiSettings
    }
  } = (0, _public.useKibana)();
  const {
    data,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (serviceName && start && end && transactionType && latencyAggregationType && preferred) {
      return callApmApi(`GET /internal/apm/services/{serviceName}/transactions/charts/latency`, {
        params: {
          path: {
            serviceName
          },
          query: {
            environment,
            kuery: '',
            start,
            end,
            transactionType,
            transactionName,
            latencyAggregationType,
            documentType: preferred.source.documentType,
            rollupInterval: preferred.source.rollupInterval,
            bucketSizeInSeconds: preferred.bucketSizeInSeconds,
            useDurationSummary: preferred.source.hasDurationSummaryField && latencyAggregationType === _latency_aggregation_types.LatencyAggregationType.avg
          }
        }
      });
    }
  }, [end, environment, latencyAggregationType, serviceName, start, transactionType, transactionName, preferred]);
  const alertEvalThreshold = alert.fields[_ruleDataUtils.ALERT_EVALUATION_THRESHOLD];
  const alertEvalThresholdChartData = alertEvalThreshold ? [/*#__PURE__*/_react.default.createElement(_observabilityAlertDetails.AlertThresholdTimeRangeRect, {
    key: 'alertThresholdRect',
    id: 'alertThresholdRect',
    threshold: alertEvalThreshold,
    alertStarted: alert.start,
    color: euiTheme.colors.danger
  }), /*#__PURE__*/_react.default.createElement(_observabilityAlertDetails.AlertThresholdAnnotation, {
    id: 'alertThresholdAnnotation',
    key: 'alertThresholdAnnotation',
    color: euiTheme.colors.danger,
    threshold: alertEvalThreshold
  })] : [];
  const getLatencyChartAdditionalData = () => {
    if ((0, _helpers.isLatencyThresholdRuleType)(alert.fields[_ruleDataUtils.ALERT_RULE_TYPE_ID])) {
      return [/*#__PURE__*/_react.default.createElement(_observabilityAlertDetails.AlertActiveTimeRangeAnnotation, {
        alertStart: alert.start,
        color: euiTheme.colors.danger,
        id: 'alertActiveRect',
        key: 'alertActiveRect'
      }), /*#__PURE__*/_react.default.createElement(_observabilityAlertDetails.AlertAnnotation, {
        key: 'alertAnnotationStart',
        id: 'alertAnnotationStart',
        alertStart: alert.start,
        color: euiTheme.colors.danger,
        dateFormat: uiSettings && uiSettings.get(_public2.UI_SETTINGS.DATE_FORMAT) || _constants.DEFAULT_DATE_FORMAT
      }), ...alertEvalThresholdChartData];
    }
  };
  const memoizedData = (0, _react.useMemo)(() => (0, _latency_chart_selectors.getLatencyChartSelector)({
    latencyChart: data,
    latencyAggregationType,
    previousPeriodLabel: ''
  }), [data, latencyAggregationType]);
  const {
    currentPeriod,
    previousPeriod
  } = memoizedData;
  const timeseriesLatency = [currentPeriod, comparisonEnabled && (0, _get_comparison_options.isTimeComparison)(offset) ? previousPeriod : undefined].filter(_latency_chart.filterNil);
  const latencyMaxY = (0, _helper.getMaxY)(timeseriesLatency);
  const latencyFormatter = (0, _common.getDurationFormatter)(latencyMaxY);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.apm.dependencyLatencyChart.chartTitle', {
    defaultMessage: 'Latency'
  }))))), /*#__PURE__*/_react.default.createElement(_timeseries_chart.TimeseriesChart, {
    id: "latencyChart",
    annotations: getLatencyChartAdditionalData(),
    height: 200,
    comparisonEnabled: comparisonEnabled,
    offset: offset,
    fetchStatus: status,
    customTheme: comparisonChartTheme,
    timeseries: timeseriesLatency,
    yLabelFormat: (0, _helper.getResponseTimeTickFormatter)(latencyFormatter),
    timeZone: timeZone
  })));
}

// eslint-disable-next-line import/no-default-export
var _default = exports.default = LatencyChart;
module.exports = exports.default;