"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertDetailsAppSection = AlertDetailsAppSection;
exports.default = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/observability-plugin/public");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireWildcard(require("react"));
var _public2 = require("@kbn/kibana-react-plugin/public");
var _observabilityGetPaddedAlertTimeRangeUtil = require("@kbn/observability-get-padded-alert-time-range-util");
var _apm = require("../../../../../common/es_fields/apm");
var _chart_pointer_event_context = require("../../../../context/chart_pointer_event/chart_pointer_event_context");
var _time_range_metadata_context = require("../../../../context/time_range_metadata/time_range_metadata_context");
var _get_comparison_chart_theme = require("../../../shared/time_comparison/get_comparison_chart_theme");
var _failed_transaction_chart = _interopRequireDefault(require("./failed_transaction_chart"));
var _helpers = require("./helpers");
var _latency_alerts_history_chart = require("./latency_alerts_history_chart");
var _latency_chart = _interopRequireDefault(require("./latency_chart"));
var _throughput_chart = _interopRequireDefault(require("./throughput_chart"));
var _create_call_apm_api = require("../../../../services/rest/create_call_apm_api");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function AlertDetailsAppSection({
  rule,
  alert,
  timeZone,
  setAlertSummaryFields
}) {
  const {
    services
  } = (0, _public2.useKibana)();
  (0, _create_call_apm_api.createCallApmApi)(services);
  const alertRuleTypeId = alert.fields[_ruleDataUtils.ALERT_RULE_TYPE_ID];
  const alertEvaluationValue = alert.fields[_ruleDataUtils.ALERT_EVALUATION_VALUE];
  const alertEvaluationThreshold = alert.fields[_ruleDataUtils.ALERT_EVALUATION_THRESHOLD];
  const environment = alert.fields[_apm.SERVICE_ENVIRONMENT];
  const serviceName = String(alert.fields[_apm.SERVICE_NAME]);
  const transactionName = alert.fields[_apm.TRANSACTION_NAME];
  const transactionType = alert.fields[_apm.TRANSACTION_TYPE];
  (0, _react.useEffect)(() => {
    const alertSummaryFields = [{
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.apm.pages.alertDetails.alertSummary.actualValue",
        defaultMessage: "Actual value"
      }),
      value: (0, _public.formatAlertEvaluationValue)(alertRuleTypeId, alertEvaluationValue)
    }, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.apm.pages.alertDetails.alertSummary.expectedValue",
        defaultMessage: "Expected value"
      }),
      value: (0, _public.formatAlertEvaluationValue)(alertRuleTypeId, alertEvaluationThreshold)
    }, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.apm.pages.alertDetails.alertSummary.serviceEnv",
        defaultMessage: "Service environment"
      }),
      value: environment
    }, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.apm.pages.alertDetails.alertSummary.serviceName",
        defaultMessage: "Service name"
      }),
      value: serviceName
    }, ...(transactionName ? [{
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.apm.pages.alertDetails.alertSummary.transactionName",
        defaultMessage: "Transaction name"
      }),
      value: transactionName
    }] : [])];
    setAlertSummaryFields(alertSummaryFields);
  }, [alertRuleTypeId, alertEvaluationValue, alertEvaluationThreshold, environment, serviceName, transactionName, setAlertSummaryFields]);
  const params = rule.params;
  const latencyAggregationType = (0, _helpers.getAggsTypeFromRule)(params.aggregationType);
  const timeRange = (0, _observabilityGetPaddedAlertTimeRangeUtil.getPaddedAlertTimeRange)(alert.fields[_ruleDataUtils.ALERT_START], alert.fields[_ruleDataUtils.ALERT_END]);
  const comparisonChartTheme = (0, _get_comparison_chart_theme.getComparisonChartTheme)();
  const historicalRange = (0, _react.useMemo)(() => {
    return {
      start: (0, _moment.default)().subtract(30, 'days').toISOString(),
      end: (0, _moment.default)().toISOString()
    };
  }, []);
  const {
    from,
    to
  } = timeRange;
  if (!from || !to) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.apm.alertDetails.error.toastTitle",
        defaultMessage: "An error occurred when identifying the alert time range."
      }),
      color: "danger",
      iconType: "error"
    }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.apm.alertDetails.error.toastDescription",
      defaultMessage: "Unable to load the alert details page's charts. Please try to refresh the page if the alert is newly created"
    })));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_time_range_metadata_context.TimeRangeMetadataContextProvider, {
    start: from,
    end: to,
    kuery: "",
    useSpanName: false,
    uiSettings: services.uiSettings
  }, /*#__PURE__*/_react.default.createElement(_chart_pointer_event_context.ChartPointerEventContextProvider, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_latency_chart.default, {
    alert: alert,
    transactionType: transactionType,
    transactionName: transactionName,
    serviceName: serviceName,
    environment: environment,
    start: from,
    end: to,
    comparisonChartTheme: comparisonChartTheme,
    timeZone: timeZone,
    latencyAggregationType: latencyAggregationType,
    comparisonEnabled: false,
    offset: ''
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_throughput_chart.default, {
    transactionType: transactionType,
    transactionName: transactionName,
    serviceName: serviceName,
    environment: environment,
    start: from,
    end: to,
    comparisonChartTheme: comparisonChartTheme,
    comparisonEnabled: false,
    offset: '',
    timeZone: timeZone
  }), /*#__PURE__*/_react.default.createElement(_failed_transaction_chart.default, {
    transactionType: transactionType,
    transactionName: transactionName,
    serviceName: serviceName,
    environment: environment,
    start: from,
    end: to,
    comparisonChartTheme: comparisonChartTheme,
    timeZone: timeZone
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_latency_alerts_history_chart.LatencyAlertsHistoryChart, {
    ruleId: alert.fields[_ruleDataUtils.ALERT_RULE_UUID],
    alertInstanceId: alert.fields[_ruleDataUtils.ALERT_INSTANCE_ID],
    serviceName: serviceName,
    start: historicalRange.start,
    end: historicalRange.end,
    transactionType: transactionType,
    transactionName: transactionName,
    latencyAggregationType: latencyAggregationType,
    environment: environment,
    timeZone: timeZone
  })))));
}

// eslint-disable-next-line import/no-default-export
var _default = exports.default = AlertDetailsAppSection;