"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLatestRuleVersion = void 0;
exports.getMinimumCompatibleVersion = getMinimumCompatibleVersion;
exports.ruleModelVersions = void 0;
var _raw_rule = require("./schemas/raw_rule");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ruleModelVersions = exports.ruleModelVersions = {
  '1': {
    changes: [],
    schemas: {
      create: _raw_rule.rawRuleSchemaV1
    },
    isCompatibleWithPreviousVersion: rawRule => true
  }
};
const getLatestRuleVersion = () => Math.max(...Object.keys(ruleModelVersions).map(Number));
exports.getLatestRuleVersion = getLatestRuleVersion;
function getMinimumCompatibleVersion(modelVersions, version, rawRule) {
  if (version === 1) {
    return 1;
  }
  if (modelVersions[version].isCompatibleWithPreviousVersion(rawRule)) {
    return getMinimumCompatibleVersion(modelVersions, version - 1, rawRule);
  }
  return version;
}