"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteMaintenanceWindowRoute = void 0;
var _lib = require("../../../lib");
var _types = require("../../../../types");
var _common = require("../../../../../common");
var _delete = require("../../../../../common/routes/maintenance_window/apis/delete");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const deleteMaintenanceWindowRoute = (router, licenseState) => {
  router.delete({
    path: `${_types.INTERNAL_ALERTING_API_MAINTENANCE_WINDOW_PATH}/{id}`,
    validate: {
      params: _delete.deleteParamsSchemaV1
    },
    options: {
      tags: [`access:${_common.MAINTENANCE_WINDOW_API_PRIVILEGES.WRITE_MAINTENANCE_WINDOW}`]
    }
  }, router.handleLegacyErrors((0, _lib.verifyAccessAndContext)(licenseState, async function (context, req, res) {
    licenseState.ensureLicenseForMaintenanceWindow();
    const params = req.params;
    const maintenanceWindowClient = (await context.alerting).getMaintenanceWindowClient();
    await maintenanceWindowClient.delete({
      id: params.id
    });
    return res.noContent();
  })));
};
exports.deleteMaintenanceWindowRoute = deleteMaintenanceWindowRoute;