"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFinishAndArchiveMaintenanceWindow = useFinishAndArchiveMaintenanceWindow;
var _i18n = require("@kbn/i18n");
var _reactQuery = require("@tanstack/react-query");
var _kibana_react = require("../utils/kibana_react");
var _finish = require("../services/maintenance_windows_api/finish");
var _archive = require("../services/maintenance_windows_api/archive");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useFinishAndArchiveMaintenanceWindow() {
  const {
    http,
    notifications: {
      toasts
    }
  } = (0, _kibana_react.useKibana)().services;
  const mutationFn = async maintenanceWindowId => {
    await (0, _finish.finishMaintenanceWindow)({
      http,
      maintenanceWindowId
    });
    return (0, _archive.archiveMaintenanceWindow)({
      http,
      maintenanceWindowId,
      archive: true
    });
  };
  return (0, _reactQuery.useMutation)(mutationFn, {
    onSuccess: data => {
      toasts.addSuccess(_i18n.i18n.translate('xpack.alerting.maintenanceWindowsFinishedAndArchiveSuccess', {
        defaultMessage: "Cancelled and archived running maintenance window '{title}'",
        values: {
          title: data.title
        }
      }));
    },
    onError: () => {
      toasts.addDanger(_i18n.i18n.translate('xpack.alerting.maintenanceWindowsFinishedAndArchiveFailure', {
        defaultMessage: 'Failed to cancel and archive maintenance window.'
      }));
    }
  });
}