"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.scheduleIdsSchema = exports.ruleSnoozeScheduleSchema = exports.ruleResponseSchema = exports.ruleParamsSchema = exports.ruleLastRunSchema = exports.ruleExecutionStatusSchema = exports.notifyWhenSchema = exports.monitoringSchema = exports.mappedParamsSchema = exports.alertDelaySchema = exports.actionParamsSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _r_rule = require("../../../r_rule");
var _alerts_filter_query = require("../../../alerts_filter_query");
var _v = require("../../common/constants/v1");
var _validation = require("../../validation");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ruleParamsSchema = exports.ruleParamsSchema = _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.maybe(_configSchema.schema.any()));
const actionParamsSchema = exports.actionParamsSchema = _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.maybe(_configSchema.schema.any()));
const mappedParamsSchema = exports.mappedParamsSchema = _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.maybe(_configSchema.schema.any()));
const notifyWhenSchema = exports.notifyWhenSchema = _configSchema.schema.oneOf([_configSchema.schema.literal(_v.ruleNotifyWhen.CHANGE), _configSchema.schema.literal(_v.ruleNotifyWhen.ACTIVE), _configSchema.schema.literal(_v.ruleNotifyWhen.THROTTLE)], {
  validate: _validation.validateNotifyWhenV1
});
const intervalScheduleSchema = _configSchema.schema.object({
  interval: _configSchema.schema.string()
});
const actionFrequencySchema = _configSchema.schema.object({
  summary: _configSchema.schema.boolean(),
  notify_when: notifyWhenSchema,
  throttle: _configSchema.schema.nullable(_configSchema.schema.string())
});
const actionAlertsFilterSchema = _configSchema.schema.object({
  query: _configSchema.schema.maybe(_alerts_filter_query.alertsFilterQuerySchemaV1),
  timeframe: _configSchema.schema.maybe(_configSchema.schema.object({
    days: _configSchema.schema.arrayOf(_configSchema.schema.oneOf([_configSchema.schema.literal(1), _configSchema.schema.literal(2), _configSchema.schema.literal(3), _configSchema.schema.literal(4), _configSchema.schema.literal(5), _configSchema.schema.literal(6), _configSchema.schema.literal(7)])),
    hours: _configSchema.schema.object({
      start: _configSchema.schema.string(),
      end: _configSchema.schema.string()
    }),
    timezone: _configSchema.schema.string()
  }))
});
const actionSchema = _configSchema.schema.object({
  uuid: _configSchema.schema.maybe(_configSchema.schema.string()),
  group: _configSchema.schema.maybe(_configSchema.schema.string()),
  id: _configSchema.schema.string(),
  connector_type_id: _configSchema.schema.string(),
  params: actionParamsSchema,
  frequency: _configSchema.schema.maybe(actionFrequencySchema),
  alerts_filter: _configSchema.schema.maybe(actionAlertsFilterSchema),
  use_alert_data_for_template: _configSchema.schema.maybe(_configSchema.schema.boolean())
});
const ruleExecutionStatusSchema = exports.ruleExecutionStatusSchema = _configSchema.schema.object({
  status: _configSchema.schema.oneOf([_configSchema.schema.literal(_v.ruleExecutionStatusValues.OK), _configSchema.schema.literal(_v.ruleExecutionStatusValues.ACTIVE), _configSchema.schema.literal(_v.ruleExecutionStatusValues.ERROR), _configSchema.schema.literal(_v.ruleExecutionStatusValues.WARNING), _configSchema.schema.literal(_v.ruleExecutionStatusValues.PENDING), _configSchema.schema.literal(_v.ruleExecutionStatusValues.UNKNOWN)]),
  last_execution_date: _configSchema.schema.string(),
  last_duration: _configSchema.schema.maybe(_configSchema.schema.number()),
  error: _configSchema.schema.maybe(_configSchema.schema.object({
    reason: _configSchema.schema.oneOf([_configSchema.schema.literal(_v.ruleExecutionStatusErrorReason.READ), _configSchema.schema.literal(_v.ruleExecutionStatusErrorReason.DECRYPT), _configSchema.schema.literal(_v.ruleExecutionStatusErrorReason.EXECUTE), _configSchema.schema.literal(_v.ruleExecutionStatusErrorReason.UNKNOWN), _configSchema.schema.literal(_v.ruleExecutionStatusErrorReason.LICENSE), _configSchema.schema.literal(_v.ruleExecutionStatusErrorReason.TIMEOUT), _configSchema.schema.literal(_v.ruleExecutionStatusErrorReason.DISABLED), _configSchema.schema.literal(_v.ruleExecutionStatusErrorReason.VALIDATE)]),
    message: _configSchema.schema.string()
  })),
  warning: _configSchema.schema.maybe(_configSchema.schema.object({
    reason: _configSchema.schema.oneOf([_configSchema.schema.literal(_v.ruleExecutionStatusWarningReason.MAX_EXECUTABLE_ACTIONS), _configSchema.schema.literal(_v.ruleExecutionStatusWarningReason.MAX_ALERTS), _configSchema.schema.literal(_v.ruleExecutionStatusWarningReason.MAX_QUEUED_ACTIONS)]),
    message: _configSchema.schema.string()
  }))
});
const ruleLastRunSchema = exports.ruleLastRunSchema = _configSchema.schema.object({
  outcome: _configSchema.schema.oneOf([_configSchema.schema.literal(_v.ruleLastRunOutcomeValues.SUCCEEDED), _configSchema.schema.literal(_v.ruleLastRunOutcomeValues.WARNING), _configSchema.schema.literal(_v.ruleLastRunOutcomeValues.FAILED)]),
  outcome_order: _configSchema.schema.maybe(_configSchema.schema.number()),
  warning: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.oneOf([_configSchema.schema.literal(_v.ruleExecutionStatusErrorReason.READ), _configSchema.schema.literal(_v.ruleExecutionStatusErrorReason.DECRYPT), _configSchema.schema.literal(_v.ruleExecutionStatusErrorReason.EXECUTE), _configSchema.schema.literal(_v.ruleExecutionStatusErrorReason.UNKNOWN), _configSchema.schema.literal(_v.ruleExecutionStatusErrorReason.LICENSE), _configSchema.schema.literal(_v.ruleExecutionStatusErrorReason.TIMEOUT), _configSchema.schema.literal(_v.ruleExecutionStatusErrorReason.DISABLED), _configSchema.schema.literal(_v.ruleExecutionStatusErrorReason.VALIDATE), _configSchema.schema.literal(_v.ruleExecutionStatusWarningReason.MAX_EXECUTABLE_ACTIONS), _configSchema.schema.literal(_v.ruleExecutionStatusWarningReason.MAX_ALERTS), _configSchema.schema.literal(_v.ruleExecutionStatusWarningReason.MAX_QUEUED_ACTIONS)]))),
  outcome_msg: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.arrayOf(_configSchema.schema.string()))),
  alerts_count: _configSchema.schema.object({
    active: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.number())),
    new: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.number())),
    recovered: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.number())),
    ignored: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.number()))
  })
});
const monitoringSchema = exports.monitoringSchema = _configSchema.schema.object({
  run: _configSchema.schema.object({
    history: _configSchema.schema.arrayOf(_configSchema.schema.object({
      success: _configSchema.schema.boolean(),
      timestamp: _configSchema.schema.number(),
      duration: _configSchema.schema.maybe(_configSchema.schema.number()),
      outcome: _configSchema.schema.maybe(ruleLastRunSchema)
    })),
    calculated_metrics: _configSchema.schema.object({
      p50: _configSchema.schema.maybe(_configSchema.schema.number()),
      p95: _configSchema.schema.maybe(_configSchema.schema.number()),
      p99: _configSchema.schema.maybe(_configSchema.schema.number()),
      success_ratio: _configSchema.schema.number()
    }),
    last_run: _configSchema.schema.object({
      timestamp: _configSchema.schema.string(),
      metrics: _configSchema.schema.object({
        duration: _configSchema.schema.maybe(_configSchema.schema.number()),
        total_search_duration_ms: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.number())),
        total_indexing_duration_ms: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.number())),
        total_alerts_detected: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.number())),
        total_alerts_created: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.number())),
        gap_duration_s: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.number()))
      })
    })
  })
});
const ruleSnoozeScheduleSchema = exports.ruleSnoozeScheduleSchema = _configSchema.schema.object({
  id: _configSchema.schema.maybe(_configSchema.schema.string()),
  duration: _configSchema.schema.number(),
  rRule: _r_rule.rRuleResponseSchemaV1,
  skipRecurrences: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string()))
});
const alertDelaySchema = exports.alertDelaySchema = _configSchema.schema.object({
  active: _configSchema.schema.number()
});
const ruleResponseSchema = exports.ruleResponseSchema = _configSchema.schema.object({
  id: _configSchema.schema.string(),
  enabled: _configSchema.schema.boolean(),
  name: _configSchema.schema.string(),
  tags: _configSchema.schema.arrayOf(_configSchema.schema.string()),
  rule_type_id: _configSchema.schema.string(),
  consumer: _configSchema.schema.string(),
  schedule: intervalScheduleSchema,
  actions: _configSchema.schema.arrayOf(actionSchema),
  params: ruleParamsSchema,
  mapped_params: _configSchema.schema.maybe(mappedParamsSchema),
  scheduled_task_id: _configSchema.schema.maybe(_configSchema.schema.string()),
  created_by: _configSchema.schema.nullable(_configSchema.schema.string()),
  updated_by: _configSchema.schema.nullable(_configSchema.schema.string()),
  created_at: _configSchema.schema.string(),
  updated_at: _configSchema.schema.string(),
  api_key_owner: _configSchema.schema.nullable(_configSchema.schema.string()),
  api_key_created_by_user: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.boolean())),
  throttle: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.string())),
  mute_all: _configSchema.schema.boolean(),
  notify_when: _configSchema.schema.maybe(_configSchema.schema.nullable(notifyWhenSchema)),
  muted_alert_ids: _configSchema.schema.arrayOf(_configSchema.schema.string()),
  execution_status: ruleExecutionStatusSchema,
  monitoring: _configSchema.schema.maybe(monitoringSchema),
  snooze_schedule: _configSchema.schema.maybe(_configSchema.schema.arrayOf(ruleSnoozeScheduleSchema)),
  active_snoozes: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  is_snoozed_until: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.string())),
  last_run: _configSchema.schema.maybe(_configSchema.schema.nullable(ruleLastRunSchema)),
  next_run: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.string())),
  revision: _configSchema.schema.number(),
  running: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.boolean())),
  view_in_app_relative_url: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.string())),
  alert_delay: _configSchema.schema.maybe(alertDelaySchema)
});
const scheduleIdsSchema = exports.scheduleIdsSchema = _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string()));