"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.streamPushPingWithTimeoutFactory = void 0;
var _actions = require("@kbn/aiops-log-rate-analysis/api/actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// 10s ping frequency to keep the stream alive.
const PING_FREQUENCY = 10000;

/**
 * Helper function that will push a ping message every 10s until the stream finishes.
 * This is implemented as a factory that receives the necessary dependencies
 * which then returns the actual helper function.
 */
const streamPushPingWithTimeoutFactory = (stateHandler, push, logDebugMessage) => {
  return function pushPingWithTimeout() {
    setTimeout(() => {
      if (stateHandler.isRunning()) {
        logDebugMessage('Ping message.');
        push((0, _actions.pingAction)());
        pushPingWithTimeout();
      }
    }, PING_FREQUENCY);
  };
};
exports.streamPushPingWithTimeoutFactory = streamPushPingWithTimeoutFactory;