"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogRateAnalysisContent = exports.LogRateAnalysis = exports.LogCategorization = exports.ChangePointDetection = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const LogRateAnalysisAppStateLazy = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./components/log_rate_analysis'))));
const LogRateAnalysisContentWrapperLazy = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./components/log_rate_analysis/log_rate_analysis_content'))));
const LazyWrapper = ({
  children
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiErrorBoundary, null, /*#__PURE__*/_react.default.createElement(_react.Suspense, {
  fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 3
  })
}, children));

/**
 * Lazy-wrapped LogRateAnalysisAppState React component
 * @param {LogRateAnalysisAppStateProps}  props - properties specifying the data on which to run the analysis.
 */
const LogRateAnalysis = props => /*#__PURE__*/_react.default.createElement(LazyWrapper, null, /*#__PURE__*/_react.default.createElement(LogRateAnalysisAppStateLazy, props));

/**
 * Lazy-wrapped LogRateAnalysisContentWrapperReact component
 * @param {LogRateAnalysisContentWrapperProps}  props - properties specifying the data on which to run the analysis.
 */
exports.LogRateAnalysis = LogRateAnalysis;
const LogRateAnalysisContent = props => /*#__PURE__*/_react.default.createElement(LazyWrapper, null, /*#__PURE__*/_react.default.createElement(LogRateAnalysisContentWrapperLazy, props));
exports.LogRateAnalysisContent = LogRateAnalysisContent;
const LogCategorizationAppStateLazy = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./components/log_categorization'))));

/**
 * Lazy-wrapped LogCategorizationAppStateProps React component
 * @param {LogCategorizationAppStateProps}  props - properties specifying the data on which to run the analysis.
 */
const LogCategorization = props => /*#__PURE__*/_react.default.createElement(LazyWrapper, null, /*#__PURE__*/_react.default.createElement(LogCategorizationAppStateLazy, props));
exports.LogCategorization = LogCategorization;
const ChangePointDetectionLazy = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./components/change_point_detection'))));
/**
 * Lazy-wrapped ChangePointDetectionAppStateProps React component
 * @param {ChangePointDetectionAppStateProps}  props - properties specifying the data on which to run the analysis.
 */
const ChangePointDetection = props => /*#__PURE__*/_react.default.createElement(LazyWrapper, null, /*#__PURE__*/_react.default.createElement(ChangePointDetectionLazy, props));
exports.ChangePointDetection = ChangePointDetection;