"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmbeddableChangePointChart = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _public = require("@kbn/embeddable-plugin/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _public3 = require("@kbn/data-plugin/public");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _lodash = require("lodash");
var _rxjs = require("rxjs");
var _constants = require("@kbn/aiops-common/constants");
var _embeddable_chart_component_wrapper = require("./embeddable_chart_component_wrapper");
var _use_aiops_app_context = require("../hooks/use_aiops_app_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class EmbeddableChangePointChart extends _public.Embeddable {
  reload() {
    this.reload$.next(Date.now());
  }
  constructor(type, deps, initialInput, parent) {
    super(initialInput, {}, parent);
    (0, _defineProperty2.default)(this, "reload$", new _rxjs.Subject());
    (0, _defineProperty2.default)(this, "node", void 0);
    // Need to defer embeddable load in order to resolve data views
    (0, _defineProperty2.default)(this, "deferEmbeddableLoad", true);
    this.type = type;
    this.deps = deps;
    this.initOutput().finally(() => this.setInitializationFinished());
  }
  async initOutput() {
    const {
      data: {
        dataViews: dataViewsService
      }
    } = this.deps;
    const {
      dataViewId
    } = this.getInput();
    const dataView = await dataViewsService.get(dataViewId);
    this.updateOutput({
      indexPatterns: [dataView]
    });
  }
  reportsEmbeddableLoad() {
    return true;
  }
  onLoading(isLoading) {
    this.renderComplete.dispatchInProgress();
    this.updateOutput({
      loading: isLoading,
      error: undefined
    });
  }
  onError(error) {
    this.renderComplete.dispatchError();
    this.updateOutput({
      loading: false,
      error: {
        name: error.name,
        message: error.message
      }
    });
  }
  onRenderComplete() {
    this.renderComplete.dispatchComplete();
    this.updateOutput({
      loading: false,
      rendered: true,
      error: undefined
    });
  }
  render(el) {
    var _ref, _this$parent$type, _this$parent;
    super.render(el);
    this.node = el;
    // required for the export feature to work
    this.node.setAttribute('data-shared-item', '');

    // test subject selector for functional tests
    this.node.setAttribute('data-test-subj', 'aiopsEmbeddableChangePointChart');
    const I18nContext = this.deps.i18n.Context;
    const datePickerDeps = {
      ...(0, _lodash.pick)(this.deps, ['data', 'http', 'notifications', 'theme', 'uiSettings', 'i18n']),
      uiSettingsKeys: _public3.UI_SETTINGS
    };
    const input = this.getInput();
    const input$ = this.getInput$();
    const aiopsAppContextValue = {
      embeddingOrigin: (_ref = (_this$parent$type = (_this$parent = this.parent) === null || _this$parent === void 0 ? void 0 : _this$parent.type) !== null && _this$parent$type !== void 0 ? _this$parent$type : input.embeddingOrigin) !== null && _ref !== void 0 ? _ref : _constants.EMBEDDABLE_ORIGIN,
      ...this.deps
    };
    _reactDom.default.render( /*#__PURE__*/_react.default.createElement(I18nContext, null, /*#__PURE__*/_react.default.createElement(_public2.KibanaThemeProvider, {
      theme$: this.deps.theme.theme$
    }, /*#__PURE__*/_react.default.createElement(_use_aiops_app_context.AiopsAppContext.Provider, {
      value: aiopsAppContextValue
    }, /*#__PURE__*/_react.default.createElement(_mlDatePicker.DatePickerContextProvider, datePickerDeps, /*#__PURE__*/_react.default.createElement(_react.Suspense, {
      fallback: null
    }, /*#__PURE__*/_react.default.createElement(_embeddable_chart_component_wrapper.EmbeddableInputTracker, {
      input$: input$,
      initialInput: input,
      reload$: this.reload$,
      onOutputChange: this.updateOutput.bind(this),
      onRenderComplete: this.onRenderComplete.bind(this),
      onLoading: this.onLoading.bind(this),
      onError: this.onError.bind(this)
    })))))), el);
  }
  destroy() {
    super.destroy();
    if (this.node) {
      _reactDom.default.unmountComponentAtNode(this.node);
    }
  }
}
exports.EmbeddableChangePointChart = EmbeddableChangePointChart;