"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogRateAnalysisResultsTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _mlAggUtils = require("@kbn/ml-agg-utils");
var _get_category_query = require("@kbn/aiops-log-pattern-analysis/get_category_query");
var _aiopsComponents = require("@kbn/aiops-components");
var _use_eui_theme = require("../../hooks/use_eui_theme");
var _mini_histogram = require("../mini_histogram");
var _use_aiops_app_context = require("../../hooks/use_aiops_app_context");
var _get_failed_transactions_correlation_impact_label = require("./get_failed_transactions_correlation_impact_label");
var _field_stats_popover = require("../field_stats_popover");
var _use_copy_to_clipboard_action = require("./use_copy_to_clipboard_action");
var _use_view_in_discover_action = require("./use_view_in_discover_action");
var _use_view_in_log_pattern_analysis_action = require("./use_view_in_log_pattern_analysis_action");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NARROW_COLUMN_WIDTH = '120px';
const ACTIONS_COLUMN_WIDTH = '60px';
const UNIQUE_COLUMN_WIDTH = '40px';
const NOT_AVAILABLE = '--';
const PAGINATION_SIZE_OPTIONS = [5, 10, 20, 50];
const DEFAULT_SORT_FIELD = 'pValue';
const DEFAULT_SORT_FIELD_ZERO_DOCS_FALLBACK = 'doc_count';
const DEFAULT_SORT_DIRECTION = 'asc';
const DEFAULT_SORT_DIRECTION_ZERO_DOCS_FALLBACK = 'desc';
const TRUNCATE_TEXT_LINES = 3;
const LogRateAnalysisResultsTable = ({
  significantItems,
  dataView,
  loading,
  isExpandedRow,
  searchQuery,
  timeRangeMs,
  barColorOverride,
  barHighlightColorOverride,
  zeroDocsFallback = false
}) => {
  const euiTheme = (0, _use_eui_theme.useEuiTheme)();
  const primaryBackgroundColor = (0, _eui.useEuiBackgroundColor)('primary');
  const dataViewId = dataView.id;
  const {
    pinnedGroup,
    pinnedSignificantItem,
    selectedGroup,
    selectedSignificantItem,
    setPinnedSignificantItem,
    setSelectedSignificantItem
  } = (0, _aiopsComponents.useLogRateAnalysisStateContext)();
  const [pageIndex, setPageIndex] = (0, _react.useState)(0);
  const [pageSize, setPageSize] = (0, _react.useState)(10);
  const [sortField, setSortField] = (0, _react.useState)(zeroDocsFallback ? DEFAULT_SORT_FIELD_ZERO_DOCS_FALLBACK : DEFAULT_SORT_FIELD);
  const [sortDirection, setSortDirection] = (0, _react.useState)(zeroDocsFallback ? DEFAULT_SORT_DIRECTION_ZERO_DOCS_FALLBACK : DEFAULT_SORT_DIRECTION);
  const {
    data,
    uiSettings,
    fieldFormats,
    charts
  } = (0, _use_aiops_app_context.useAiopsAppContext)();
  const fieldStatsServices = (0, _react.useMemo)(() => {
    return {
      uiSettings,
      dataViews: data.dataViews,
      data,
      fieldFormats,
      charts
    };
  }, [uiSettings, data, fieldFormats, charts]);
  const copyToClipBoardAction = (0, _use_copy_to_clipboard_action.useCopyToClipboardAction)();
  const viewInDiscoverAction = (0, _use_view_in_discover_action.useViewInDiscoverAction)(dataViewId);
  const viewInLogPatternAnalysisAction = (0, _use_view_in_log_pattern_analysis_action.useViewInLogPatternAnalysisAction)(dataViewId);
  const columns = [{
    'data-test-subj': 'aiopsLogRateAnalysisResultsTableColumnFieldName',
    field: 'fieldName',
    name: _i18n.i18n.translate('xpack.aiops.logRateAnalysis.resultsTable.fieldNameLabel', {
      defaultMessage: 'Field name'
    }),
    render: (_, {
      fieldName,
      fieldValue,
      key,
      type,
      doc_count: count
    }) => {
      const dslQuery = type === _mlAggUtils.SIGNIFICANT_ITEM_TYPE.KEYWORD ? searchQuery : (0, _get_category_query.getCategoryQuery)(fieldName, [{
        key,
        count,
        examples: [],
        regex: ''
      }]);
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, type === _mlAggUtils.SIGNIFICANT_ITEM_TYPE.KEYWORD && /*#__PURE__*/_react.default.createElement(_field_stats_popover.FieldStatsPopover, {
        dataView: dataView,
        fieldName: fieldName,
        fieldValue: type === _mlAggUtils.SIGNIFICANT_ITEM_TYPE.KEYWORD ? fieldValue : key,
        fieldStatsServices: fieldStatsServices,
        dslQuery: dslQuery,
        timeRangeMs: timeRangeMs
      }), type === _mlAggUtils.SIGNIFICANT_ITEM_TYPE.LOG_PATTERN && /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: _i18n.i18n.translate('xpack.aiops.fieldContextPopover.descriptionTooltipLogPattern', {
          defaultMessage: 'The field value for this field shows an example of the identified significant text field pattern.'
        })
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "aggregate",
        "data-test-subj": 'aiopsLogPatternIcon',
        css: {
          marginLeft: euiTheme.euiSizeS,
          marginRight: euiTheme.euiSizeXS
        },
        size: "m"
      })), /*#__PURE__*/_react.default.createElement("span", {
        title: fieldName
      }, fieldName));
    },
    sortable: true,
    truncateText: true,
    valign: 'middle'
  }, {
    'data-test-subj': 'aiopsLogRateAnalysisResultsTableColumnFieldValue',
    field: 'fieldValue',
    name: _i18n.i18n.translate('xpack.aiops.logRateAnalysis.resultsTable.fieldValueLabel', {
      defaultMessage: 'Field value'
    }),
    render: (_, {
      fieldValue,
      type
    }) => /*#__PURE__*/_react.default.createElement("span", {
      title: String(fieldValue)
    }, type === 'keyword' ? String(fieldValue) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
      language: "log",
      transparentBackground: true,
      css: {
        paddingInline: '0px'
      }
    }, String(fieldValue)))),
    sortable: true,
    textOnly: true,
    truncateText: {
      lines: TRUNCATE_TEXT_LINES
    },
    valign: 'middle'
  }, {
    'data-test-subj': 'aiopsLogRateAnalysisResultsTableColumnLogRate',
    width: NARROW_COLUMN_WIDTH,
    field: 'pValue',
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: _i18n.i18n.translate('xpack.aiops.logRateAnalysis.resultsTable.logRateColumnTooltip', {
        defaultMessage: 'A visual representation of the impact of the field on the message rate difference'
      })
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.aiops.logRateAnalysis.resultsTable.logRateLabel",
      defaultMessage: "Log rate"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "s",
      color: "subdued",
      type: "questionInCircle",
      className: "eui-alignTop"
    }))),
    render: (_, {
      histogram,
      fieldName,
      fieldValue
    }) => /*#__PURE__*/_react.default.createElement(_mini_histogram.MiniHistogram, {
      chartData: histogram,
      isLoading: loading && histogram === undefined,
      label: `${fieldName}:${fieldValue}`,
      barColorOverride: barColorOverride,
      barHighlightColorOverride: barHighlightColorOverride
    }),
    sortable: false,
    valign: 'middle'
  }, {
    'data-test-subj': 'aiopsLogRateAnalysisResultsTableColumnDocCount',
    width: NARROW_COLUMN_WIDTH,
    field: 'doc_count',
    name: _i18n.i18n.translate('xpack.aiops.logRateAnalysis.resultsTable.docCountLabel', {
      defaultMessage: 'Doc count'
    }),
    sortable: true,
    valign: 'middle'
  }];
  if (!zeroDocsFallback) {
    columns.push({
      'data-test-subj': 'aiopsLogRateAnalysisResultsTableColumnPValue',
      width: NARROW_COLUMN_WIDTH,
      field: 'pValue',
      name: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        position: "top",
        content: _i18n.i18n.translate('xpack.aiops.logRateAnalysis.resultsTable.pValueColumnTooltip', {
          defaultMessage: 'The significance of changes in the frequency of values; lower values indicate greater change; sorting this column will automatically do a secondary sort on the doc count column.'
        })
      }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.aiops.logRateAnalysis.resultsTable.pValueLabel",
        defaultMessage: "p-value"
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        size: "s",
        color: "subdued",
        type: "questionInCircle",
        className: "eui-alignTop"
      }))),
      render: pValue => {
        var _pValue$toPrecision;
        return (_pValue$toPrecision = pValue === null || pValue === void 0 ? void 0 : pValue.toPrecision(3)) !== null && _pValue$toPrecision !== void 0 ? _pValue$toPrecision : NOT_AVAILABLE;
      },
      sortable: true,
      valign: 'middle'
    });
    columns.push({
      'data-test-subj': 'aiopsLogRateAnalysisResultsTableColumnImpact',
      width: NARROW_COLUMN_WIDTH,
      field: 'pValue',
      name: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        position: "top",
        content: _i18n.i18n.translate('xpack.aiops.logRateAnalysis.resultsTable.impactLabelColumnTooltip', {
          defaultMessage: 'The level of impact of the field on the message rate difference.'
        })
      }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.aiops.logRateAnalysis.resultsTable.impactLabel",
        defaultMessage: "Impact"
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        size: "s",
        color: "subdued",
        type: "questionInCircle",
        className: "eui-alignTop"
      }))),
      render: (_, {
        pValue
      }) => {
        if (typeof pValue !== 'number') return NOT_AVAILABLE;
        const label = (0, _get_failed_transactions_correlation_impact_label.getFailedTransactionsCorrelationImpactLabel)(pValue);
        return label ? /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          color: label.color
        }, label.impact) : null;
      },
      sortable: true,
      valign: 'middle'
    });
  }
  columns.push({
    'data-test-subj': 'aiopsLogRateAnalysisResultsTableColumnAction',
    name: _i18n.i18n.translate('xpack.aiops.logRateAnalysis.resultsTable.actionsColumnName', {
      defaultMessage: 'Actions'
    }),
    actions: [...(viewInDiscoverAction ? [viewInDiscoverAction] : []), ...(viewInLogPatternAnalysisAction ? [viewInLogPatternAnalysisAction] : []), copyToClipBoardAction],
    width: ACTIONS_COLUMN_WIDTH,
    valign: 'middle'
  });
  if (isExpandedRow === true) {
    columns.unshift({
      'data-test-subj': 'aiopsLogRateAnalysisResultsTableColumnUnique',
      width: UNIQUE_COLUMN_WIDTH,
      field: 'unique',
      name: '',
      render: (_, {
        unique
      }) => {
        if (unique) {
          return /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
            content: _i18n.i18n.translate('xpack.aiops.logRateAnalysis.resultsTable.uniqueColumnTooltip', {
              defaultMessage: 'This field/value pair only appears in this group'
            }),
            position: "top",
            type: "asterisk"
          });
        }
        return '';
      },
      sortable: false,
      valign: 'middle'
    });
  }
  const onChange = (0, _react.useCallback)(tableSettings => {
    if (tableSettings.page) {
      const {
        index,
        size
      } = tableSettings.page;
      setPageIndex(index);
      setPageSize(size);
    }
    if (tableSettings.sort) {
      const {
        field,
        direction
      } = tableSettings.sort;
      setSortField(field);
      setSortDirection(direction);
    }
  }, []);
  const {
    pagination,
    pageOfItems,
    sorting
  } = (0, _react.useMemo)(() => {
    var _significantItems$len;
    const pageStart = pageIndex * pageSize;
    const itemCount = (_significantItems$len = significantItems === null || significantItems === void 0 ? void 0 : significantItems.length) !== null && _significantItems$len !== void 0 ? _significantItems$len : 0;
    let items = significantItems !== null && significantItems !== void 0 ? significantItems : [];
    const sortIteratees = [item => {
      if (item && typeof item[sortField] === 'string') {
        // @ts-ignore Object is possibly null or undefined
        return item[sortField].toLowerCase();
      }
      return item[sortField];
    }];
    const sortDirections = [sortDirection];

    // Only if the table is sorted by p-value, add a secondary sort by doc count.
    if (sortField === 'pValue') {
      sortIteratees.push(item => item.doc_count);
      sortDirections.push(sortDirection);
    }
    items = (0, _lodash.orderBy)(significantItems, sortIteratees, sortDirections);
    return {
      pageOfItems: items.slice(pageStart, pageStart + pageSize),
      pagination: {
        pageIndex,
        pageSize,
        totalItemCount: itemCount,
        pageSizeOptions: PAGINATION_SIZE_OPTIONS
      },
      sorting: {
        sort: {
          field: sortField,
          direction: sortDirection
        }
      }
    };
  }, [pageIndex, pageSize, sortField, sortDirection, significantItems]);
  (0, _react.useEffect)(() => {
    // If no row is hovered or pinned or the user switched to a new page,
    // fall back to set the first row into a hovered state to make the
    // main document count chart show a comparison view by default.
    if ((selectedSignificantItem === null || !pageOfItems.some(item => (0, _lodash.isEqual)(item, selectedSignificantItem))) && pinnedSignificantItem === null && pageOfItems.length > 0 && selectedGroup === null && pinnedGroup === null) {
      setSelectedSignificantItem(pageOfItems[0]);
    }

    // If a user switched pages and a pinned row is no longer visible
    // on the current page, set the status of pinned rows back to `null`.
    if (pinnedSignificantItem !== null && !pageOfItems.some(item => (0, _lodash.isEqual)(item, pinnedSignificantItem)) && selectedGroup === null && pinnedGroup === null) {
      setPinnedSignificantItem(null);
    }
  }, [selectedGroup, selectedSignificantItem, setSelectedSignificantItem, setPinnedSignificantItem, pageOfItems, pinnedGroup, pinnedSignificantItem]);

  // When the analysis results table unmounts,
  // make sure to reset any hovered or pinned rows.
  (0, _react.useEffect)(() => () => {
    setSelectedSignificantItem(null);
    setPinnedSignificantItem(null);
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  []);
  const getRowStyle = significantItem => {
    if (pinnedSignificantItem && pinnedSignificantItem.fieldName === significantItem.fieldName && pinnedSignificantItem.fieldValue === significantItem.fieldValue) {
      return {
        backgroundColor: primaryBackgroundColor
      };
    }
    if (selectedSignificantItem && selectedSignificantItem.fieldName === significantItem.fieldName && selectedSignificantItem.fieldValue === significantItem.fieldValue) {
      return {
        backgroundColor: euiTheme.euiColorLightestShade
      };
    }
    return {
      backgroundColor: euiTheme.euiColorEmptyShade
    };
  };

  // Don't pass on the `loading` state to the table itself because
  // it disables hovering events. Because the mini histograms take a while
  // to load, hovering would not update the main chart. Instead,
  // the loading state is shown by the progress bar on the outer component level.
  // The outer component also will display a prompt when no data was returned
  // running the analysis and will hide this table.

  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    "data-test-subj": "aiopsLogRateAnalysisResultsTable",
    compressed: true,
    columns: columns,
    items: pageOfItems,
    onChange: onChange,
    pagination: pagination.totalItemCount > pagination.pageSize ? pagination : undefined,
    loading: false,
    sorting: sorting,
    rowProps: significantItem => {
      return {
        'data-test-subj': `aiopsLogRateAnalysisResultsTableRow row-${significantItem.fieldName}-${significantItem.fieldValue}`,
        onClick: () => {
          if (significantItem.fieldName === (pinnedSignificantItem === null || pinnedSignificantItem === void 0 ? void 0 : pinnedSignificantItem.fieldName) && significantItem.fieldValue === (pinnedSignificantItem === null || pinnedSignificantItem === void 0 ? void 0 : pinnedSignificantItem.fieldValue)) {
            setPinnedSignificantItem(null);
          } else {
            setPinnedSignificantItem(significantItem);
          }
        },
        onMouseEnter: () => {
          if (pinnedSignificantItem === null) {
            setSelectedSignificantItem(significantItem);
          }
        },
        onMouseLeave: () => {
          setSelectedSignificantItem(null);
        },
        style: getRowStyle(significantItem)
      };
    }
  });
};
exports.LogRateAnalysisResultsTable = LogRateAnalysisResultsTable;