"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogRateAnalysisContent = void 0;
exports.getDocumentCountStatsSplitLabel = getDocumentCountStatsSplitLabel;
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _aiopsLogRateAnalysis = require("@kbn/aiops-log-rate-analysis");
var _aiopsComponents = require("@kbn/aiops-components");
var _use_data = require("../../../hooks/use_data");
var _document_count_content = require("../../document_count_content/document_count_content");
var _log_rate_analysis_results = require("../log_rate_analysis_results");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_SEARCH_QUERY = {
  match_all: {}
};
const DEFAULT_SEARCH_BAR_QUERY = {
  bool: {
    filter: [],
    must: [{
      match_all: {}
    }],
    must_not: []
  }
};
function getDocumentCountStatsSplitLabel(significantItem, group) {
  if (significantItem) {
    return `${significantItem === null || significantItem === void 0 ? void 0 : significantItem.fieldName}:${significantItem === null || significantItem === void 0 ? void 0 : significantItem.fieldValue}`;
  } else if (group) {
    return _i18n.i18n.translate('xpack.aiops.logRateAnalysis.page.documentCountStatsSplitGroupLabel', {
      defaultMessage: 'Selected group'
    });
  }
}
const LogRateAnalysisContent = ({
  dataView,
  timeRange,
  esSearchQuery = DEFAULT_SEARCH_QUERY,
  stickyHistogram,
  barColorOverride,
  barHighlightColorOverride,
  onAnalysisCompleted,
  onWindowParametersChange,
  embeddingOrigin
}) => {
  var _documentCountStats$c;
  const [windowParameters, setWindowParameters] = (0, _react.useState)();
  const [isBrushCleared, setIsBrushCleared] = (0, _react.useState)(true);
  const [logRateAnalysisType, setLogRateAnalysisType] = (0, _react.useState)(_aiopsLogRateAnalysis.LOG_RATE_ANALYSIS_TYPE.SPIKE);
  (0, _react.useEffect)(() => {
    setIsBrushCleared(windowParameters === undefined);
  }, [windowParameters]);

  // Window parameters stored in the url state use this components
  // `initialAnalysisStart` prop to set the initial params restore from url state.
  // To avoid a loop with window parameters being passed around on load,
  // the following ref and useEffect are used to check wether it's safe to call
  // the `onWindowParametersChange` callback.
  const windowParametersTouched = (0, _react.useRef)(false);
  (0, _react.useEffect)(() => {
    // Don't continue if window parameters were not touched yet.
    // Because they can be reset to `undefined` at a later stage again when a user
    // clears the selections, we cannot rely solely on checking if they are
    // `undefined`, we need the additional ref to update on the first change.
    if (!windowParametersTouched.current && windowParameters === undefined) {
      return;
    }
    windowParametersTouched.current = true;
    if (onWindowParametersChange) {
      onWindowParametersChange(windowParameters, true);
    }
  }, [onWindowParametersChange, windowParameters]);

  // Checks if `esSearchQuery` is the default empty query passed on from the search bar
  // and if that's the case fall back to a simpler match all query.
  const searchQuery = (0, _react.useMemo)(() => (0, _lodash.isEqual)(esSearchQuery, DEFAULT_SEARCH_BAR_QUERY) ? DEFAULT_SEARCH_QUERY : esSearchQuery, [esSearchQuery]);
  const {
    autoRunAnalysis,
    currentSelectedSignificantItem,
    currentSelectedGroup,
    setAutoRunAnalysis,
    setInitialAnalysisStart,
    setPinnedSignificantItem,
    setPinnedGroup,
    setSelectedSignificantItem,
    setSelectedGroup
  } = (0, _aiopsComponents.useLogRateAnalysisStateContext)();
  const {
    documentStats,
    earliest,
    latest
  } = (0, _use_data.useData)(dataView, 'log_rate_analysis', searchQuery, undefined, currentSelectedSignificantItem, currentSelectedGroup, undefined, timeRange);
  const {
    sampleProbability,
    totalCount,
    documentCountStats,
    documentCountStatsCompare
  } = documentStats;
  function brushSelectionUpdate(windowParametersUpdate, force, logRateAnalysisTypeUpdate) {
    if (!isBrushCleared || force) {
      setWindowParameters(windowParametersUpdate);
    }
    if (force) {
      setIsBrushCleared(false);
    }
    setLogRateAnalysisType(logRateAnalysisTypeUpdate);
  }
  function clearSelection() {
    setWindowParameters(undefined);
    setPinnedSignificantItem(null);
    setPinnedGroup(null);
    setSelectedSignificantItem(null);
    setSelectedGroup(null);
    setIsBrushCleared(true);
    setInitialAnalysisStart(undefined);
  }
  const barStyle = {
    rect: {
      opacity: 1,
      fill: _aiopsLogRateAnalysis.LOG_RATE_ANALYSIS_HIGHLIGHT_COLOR
    }
  };

  // Used to highlight an auto-detected change point in the date histogram.
  const barStyleAccessor = isBrushCleared && documentCountStats !== null && documentCountStats !== void 0 && documentCountStats.changePoint ? (d, g) => {
    return g.specId === 'document_count' && documentCountStats !== null && documentCountStats !== void 0 && documentCountStats.changePoint && d.x > documentCountStats.changePoint.startTs && d.x < documentCountStats.changePoint.endTs ? barStyle : null;
  } : undefined;
  const triggerAnalysisForManualSelection = (0, _react.useCallback)(() => {
    setAutoRunAnalysis(true);
  }, [setAutoRunAnalysis]);
  const triggerAnalysisForChangePoint = (0, _react.useCallback)(() => {
    if (documentCountStats) {
      const {
        interval,
        timeRangeEarliest,
        timeRangeLatest,
        changePoint
      } = documentCountStats;
      if (changePoint && interval && timeRangeEarliest && timeRangeLatest) {
        const wp = (0, _aiopsLogRateAnalysis.getWindowParametersForTrigger)(changePoint.startTs, interval, timeRangeEarliest, timeRangeLatest, changePoint);
        const snapTimestamps = (0, _aiopsLogRateAnalysis.getSnappedTimestamps)(timeRangeEarliest, timeRangeLatest, interval);
        const wpSnap = (0, _aiopsLogRateAnalysis.getSnappedWindowParameters)(wp, snapTimestamps);
        triggerAnalysisForManualSelection();
        setInitialAnalysisStart(wpSnap);
      }
    }
  }, [documentCountStats, setInitialAnalysisStart, triggerAnalysisForManualSelection]);
  const showDocumentCountContent = documentCountStats !== undefined;
  const showLogRateAnalysisResults = autoRunAnalysis && earliest !== undefined && latest !== undefined && windowParameters !== undefined;
  const showNoAutoRunEmptyPrompt = !autoRunAnalysis && earliest !== undefined && latest !== undefined && windowParameters !== undefined;
  const showSpikeDetectedEmptyPrompt = windowParameters === undefined && (documentCountStats === null || documentCountStats === void 0 ? void 0 : documentCountStats.changePoint);
  const showDefaultEmptyPrompt = windowParameters === undefined && (documentCountStats === null || documentCountStats === void 0 ? void 0 : documentCountStats.changePoint) === undefined;
  const changePointType = documentCountStats === null || documentCountStats === void 0 ? void 0 : (_documentCountStats$c = documentCountStats.changePoint) === null || _documentCountStats$c === void 0 ? void 0 : _documentCountStats$c.type;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: false,
    hasShadow: false
  }, showDocumentCountContent && /*#__PURE__*/_react.default.createElement(_document_count_content.DocumentCountContent, {
    brushSelectionUpdateHandler: brushSelectionUpdate,
    documentCountStats: documentCountStats,
    documentCountStatsSplit: documentCountStatsCompare,
    documentCountStatsSplitLabel: getDocumentCountStatsSplitLabel(currentSelectedSignificantItem, currentSelectedGroup),
    isBrushCleared: isBrushCleared,
    totalCount: totalCount,
    sampleProbability: sampleProbability,
    barColorOverride: barColorOverride,
    barHighlightColorOverride: barHighlightColorOverride,
    barStyleAccessor: barStyleAccessor
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), showLogRateAnalysisResults && /*#__PURE__*/_react.default.createElement(_log_rate_analysis_results.LogRateAnalysisResults, {
    dataView: dataView,
    analysisType: logRateAnalysisType,
    earliest: earliest,
    isBrushCleared: isBrushCleared,
    latest: latest,
    stickyHistogram: stickyHistogram,
    onReset: clearSelection,
    sampleProbability: sampleProbability,
    searchQuery: searchQuery,
    windowParameters: windowParameters,
    barColorOverride: barColorOverride,
    barHighlightColorOverride: barHighlightColorOverride,
    onAnalysisCompleted: onAnalysisCompleted,
    embeddingOrigin: embeddingOrigin
  }), showNoAutoRunEmptyPrompt && /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    color: "subdued",
    hasShadow: false,
    hasBorder: false,
    css: {
      minWidth: '100%'
    },
    title: undefined,
    titleSize: "xs",
    body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.aiops.logRateAnalysis.page.noAutoRunPromptBody",
      defaultMessage: "Next you can fine tune the time ranges for baseline and deviation by dragging the handles of the brushes. Once you're ready, click the button 'Run analysis' below."
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "aiopsLogRateAnalysisNoAutoRunContentRunAnalysisButton",
      onClick: triggerAnalysisForManualSelection
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.aiops.logRateAnalysis.page.noAutoRunPromptRunAnalysisButton",
      defaultMessage: "Run analysis"
    })), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "aiopsClearSelectionBadge",
      onClick: () => clearSelection(),
      color: "text"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.aiops.clearSelectionLabel",
      defaultMessage: "Clear selection"
    }))),
    "data-test-subj": "aiopsChangePointDetectedPrompt"
  }), showSpikeDetectedEmptyPrompt && /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    color: "subdued",
    hasShadow: false,
    hasBorder: false,
    css: {
      minWidth: '100%'
    },
    title: /*#__PURE__*/_react.default.createElement("h2", null, changePointType === _aiopsLogRateAnalysis.LOG_RATE_ANALYSIS_TYPE.SPIKE && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.aiops.logRateAnalysis.page.changePointSpikePromptTitle",
      defaultMessage: "Log rate spike detected"
    }), changePointType === _aiopsLogRateAnalysis.LOG_RATE_ANALYSIS_TYPE.DIP && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.aiops.logRateAnalysis.page.changePointDipPromptTitle",
      defaultMessage: "Log rate dip detected"
    }), changePointType !== _aiopsLogRateAnalysis.LOG_RATE_ANALYSIS_TYPE.SPIKE && changePointType !== _aiopsLogRateAnalysis.LOG_RATE_ANALYSIS_TYPE.DIP && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.aiops.logRateAnalysis.page.changePointOtherPromptTitle",
      defaultMessage: "Log rate change point detected"
    })),
    titleSize: "xs",
    body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.aiops.logRateAnalysis.page.changePointPromptBody",
      defaultMessage: "The log rate analysis feature identifies statistically significant field/value combinations that contribute to a log rate spike or dip. To analyse the area highlighted in the chart, click the button below. For custom analysis of other areas, start by clicking on any of the non-highlighted bars in the histogram chart."
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "aiopsLogRateAnalysisContentRunAnalysisButton",
      onClick: triggerAnalysisForChangePoint
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.aiops.logRateAnalysis.page.changePointPromptRunAnalysisButton",
      defaultMessage: "Run analysis"
    }))),
    "data-test-subj": "aiopsChangePointDetectedPrompt"
  }), showDefaultEmptyPrompt && /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    color: "subdued",
    hasShadow: false,
    hasBorder: false,
    css: {
      minWidth: '100%'
    },
    title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.aiops.logRateAnalysis.page.emptyPromptTitle",
      defaultMessage: "Start by clicking a spike or dip in the histogram chart."
    })),
    titleSize: "xs",
    body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.aiops.logRateAnalysis.page.emptyPromptBody",
      defaultMessage: "The log rate analysis feature identifies statistically significant field/value combinations that contribute to a log rate spike or dip."
    })),
    "data-test-subj": "aiopsNoWindowParametersEmptyPrompt"
  }));
};
exports.LogRateAnalysisContent = LogRateAnalysisContent;