"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RandomSampler = exports.RANDOM_SAMPLER_STEP = exports.RANDOM_SAMPLER_SELECT_OPTIONS = exports.RANDOM_SAMPLER_PROBABILITIES = exports.RANDOM_SAMPLER_OPTION = exports.MIN_SAMPLER_PROBABILITY = exports.DEFAULT_PROBABILITY = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _mlRandomSamplerUtils = require("@kbn/ml-random-sampler-utils");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RANDOM_SAMPLER_PROBABILITIES = exports.RANDOM_SAMPLER_PROBABILITIES = [0.00001, 0.00005, 0.0001, 0.0005, 0.001, 0.005, 0.01, 0.05, 0.1, 0.2, 0.3, 0.4, 0.5].map(n => n * 100);
const MIN_SAMPLER_PROBABILITY = exports.MIN_SAMPLER_PROBABILITY = 0.00001;
const RANDOM_SAMPLER_STEP = exports.RANDOM_SAMPLER_STEP = MIN_SAMPLER_PROBABILITY * 100;
const DEFAULT_PROBABILITY = exports.DEFAULT_PROBABILITY = 0.001;
const RANDOM_SAMPLER_OPTION = exports.RANDOM_SAMPLER_OPTION = {
  ON_AUTOMATIC: 'on_automatic',
  ON_MANUAL: 'on_manual',
  OFF: 'off'
};
const RANDOM_SAMPLER_SELECT_OPTIONS = exports.RANDOM_SAMPLER_SELECT_OPTIONS = [{
  'data-test-subj': 'aiopsRandomSamplerOptionOnAutomatic',
  value: RANDOM_SAMPLER_OPTION.ON_AUTOMATIC,
  text: _i18n.i18n.translate('xpack.aiops.logCategorization.randomSamplerPreference.onAutomaticLabel', {
    defaultMessage: 'On - automatic'
  })
}, {
  'data-test-subj': 'aiopsRandomSamplerOptionOnManual',
  value: RANDOM_SAMPLER_OPTION.ON_MANUAL,
  text: _i18n.i18n.translate('xpack.aiops.logCategorization.randomSamplerPreference.onManualLabel', {
    defaultMessage: 'On - manual'
  })
}, {
  'data-test-subj': 'aiopsRandomSamplerOptionOff',
  value: RANDOM_SAMPLER_OPTION.OFF,
  text: _i18n.i18n.translate('xpack.aiops.logCategorization.randomSamplerPreference.offLabel', {
    defaultMessage: 'Off'
  })
}];
class RandomSampler {
  constructor(randomSamplerMode, setRandomSamplerMode, randomSamplerProbability, setRandomSamplerProbability) {
    (0, _defineProperty2.default)(this, "docCount$", new _rxjs.BehaviorSubject(0));
    (0, _defineProperty2.default)(this, "mode$", new _rxjs.BehaviorSubject(RANDOM_SAMPLER_OPTION.ON_AUTOMATIC));
    (0, _defineProperty2.default)(this, "probability$", new _rxjs.BehaviorSubject(DEFAULT_PROBABILITY));
    (0, _defineProperty2.default)(this, "setRandomSamplerModeInStorage", void 0);
    (0, _defineProperty2.default)(this, "setRandomSamplerProbabilityInStorage", void 0);
    this.mode$.next(randomSamplerMode);
    this.setRandomSamplerModeInStorage = setRandomSamplerMode;
    this.probability$.next(randomSamplerProbability);
    this.setRandomSamplerProbabilityInStorage = setRandomSamplerProbability;
  }
  setDocCount(docCount) {
    return this.docCount$.next(docCount);
  }
  getDocCount() {
    return this.docCount$.getValue();
  }
  setMode(mode) {
    this.setRandomSamplerModeInStorage(mode);
    return this.mode$.next(mode);
  }
  getMode$() {
    return this.mode$.asObservable();
  }
  getMode() {
    return this.mode$.getValue();
  }
  setProbability(probability) {
    this.setRandomSamplerProbabilityInStorage(probability);
    return this.probability$.next(probability);
  }
  getProbability$() {
    return this.probability$.asObservable();
  }
  getProbability() {
    return this.probability$.getValue();
  }
  createRandomSamplerWrapper() {
    const mode = this.getMode();
    const probability = this.getProbability();
    let prob = {};
    if (mode === RANDOM_SAMPLER_OPTION.ON_MANUAL) {
      prob = {
        probability
      };
    } else if (mode === RANDOM_SAMPLER_OPTION.OFF) {
      prob = {
        probability: 1
      };
    }
    const wrapper = (0, _mlRandomSamplerUtils.createRandomSamplerWrapper)({
      ...prob,
      totalNumDocs: this.getDocCount()
    });
    this.setProbability(wrapper.probability);
    return wrapper;
  }
}
exports.RandomSampler = RandomSampler;