"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSplitFieldCardinality = useSplitFieldCardinality;
var _react = require("react");
var _usePrevious = _interopRequireDefault(require("react-use/lib/usePrevious"));
var _change_point_detection_context = require("./change_point_detection_context");
var _use_cancellable_search = require("../../hooks/use_cancellable_search");
var _use_data_source = require("../../hooks/use_data_source");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Gets the cardinality of the selected split field
 * @param splitField
 * @param query
 */
function useSplitFieldCardinality(splitField, query) {
  const prevSplitField = (0, _usePrevious.default)(splitField);
  const {
    splitFieldsOptions
  } = (0, _change_point_detection_context.useChangePointDetectionControlsContext)();
  const [cardinality, setCardinality] = (0, _react.useState)(null);
  const {
    dataView
  } = (0, _use_data_source.useDataSource)();
  const requestPayload = (0, _react.useMemo)(() => {
    const optionDefinition = splitFieldsOptions.find(option => option.name === splitField);
    let runtimeMappings = {};
    if (optionDefinition !== null && optionDefinition !== void 0 && optionDefinition.isRuntimeField) {
      runtimeMappings = {
        runtime_mappings: {
          [optionDefinition.name]: optionDefinition.runtimeField
        }
      };
    }
    return {
      params: {
        index: dataView.getIndexPattern(),
        size: 0,
        body: {
          query,
          aggregations: {
            fieldCount: {
              cardinality: {
                field: splitField
              }
            }
          },
          ...runtimeMappings
        }
      }
    };
  }, [splitField, dataView, query, splitFieldsOptions]);
  const {
    runRequest: getSplitFieldCardinality,
    cancelRequest
  } = (0, _use_cancellable_search.useCancellableSearch)();
  (0, _react.useEffect)(function performCardinalityCheck() {
    setCardinality(null);
    if (splitField === undefined) {
      return;
    }
    cancelRequest();
    getSplitFieldCardinality(requestPayload).then(response => {
      if (response !== null && response !== void 0 && response.rawResponse.aggregations) {
        setCardinality(response.rawResponse.aggregations.fieldCount.value);
      }
    });
  }, [getSplitFieldCardinality, requestPayload, cancelRequest, splitField]);
  return prevSplitField !== splitField ? null : cardinality;
}