"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerChangePointChartsAttachment = registerChangePointChartsAttachment;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("@kbn/aiops-change-point-detection/constants");
var _embeddable_change_point_chart_component = require("../embeddable/embeddable_change_point_chart_component");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function registerChangePointChartsAttachment(cases, coreStart, pluginStart) {
  const EmbeddableComponent = (0, _embeddable_change_point_chart_component.getEmbeddableChangePointChart)(_constants.EMBEDDABLE_CHANGE_POINT_CHART_TYPE, coreStart, pluginStart);
  cases.attachmentFramework.registerPersistableState({
    id: _constants.CASES_ATTACHMENT_CHANGE_POINT_CHART,
    icon: 'machineLearningApp',
    displayName: _i18n.i18n.translate('xpack.aiops.changePointDetection.cases.attachmentName', {
      defaultMessage: 'Change point chart'
    }),
    getAttachmentViewObject: () => ({
      event: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.aiops.changePointDetection.cases.attachmentEvent",
        defaultMessage: "added change point chart"
      }),
      timelineAvatar: 'machineLearningApp',
      children: /*#__PURE__*/_react.default.lazy(async () => {
        const {
          initComponent
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./change_point_charts_attachment')));
        return {
          default: initComponent(pluginStart.fieldFormats, EmbeddableComponent)
        };
      })
    })
  });
}