"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createCategorizeQuery = createCategorizeQuery;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createCategorizeQuery(queryIn, timeField, timeRange) {
  const query = (0, _lodash.cloneDeep)(queryIn !== null && queryIn !== void 0 ? queryIn : {
    match_all: {}
  });
  if (query.bool === undefined) {
    query.bool = {};
  }
  if (query.bool.must === undefined) {
    query.bool.must = [];
    if (query.match_all !== undefined) {
      query.bool.must.push({
        match_all: query.match_all
      });
      delete query.match_all;
    }
  }
  if (query.multi_match !== undefined) {
    query.bool.should = {
      multi_match: query.multi_match
    };
    delete query.multi_match;
  }
  if (timeRange !== undefined) {
    query.bool.must.push({
      range: {
        [timeField]: {
          gte: timeRange.from,
          lte: timeRange.to,
          format: 'epoch_millis'
        }
      }
    });
  }
  return query;
}