"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConnectorRoute = void 0;
var _get = require("../../../../common/routes/connector/apis/get");
var _transforms = require("./transforms");
var _common = require("../../../../common");
var _verify_access_and_context = require("../../verify_access_and_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getConnectorRoute = (router, licenseState) => {
  router.get({
    path: `${_common.BASE_ACTION_API_PATH}/connector/{id}`,
    options: {
      access: 'public',
      description: `Get connector information`
    },
    validate: {
      params: _get.getConnectorParamsSchemaV1
    }
  }, router.handleLegacyErrors((0, _verify_access_and_context.verifyAccessAndContext)(licenseState, async function (context, req, res) {
    const actionsClient = (await context.actions).getActionsClient();
    const {
      id
    } = req.params;
    return res.ok({
      body: (0, _transforms.transformGetConnectorResponseV1)(await actionsClient.get({
        id
      }))
    });
  })));
};
exports.getConnectorRoute = getConnectorRoute;