"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMustacheLambdas = getMustacheLambdas;
var tinymath = _interopRequireWildcard(require("@kbn/tinymath"));
var _hjson = require("hjson");
var _momentTimezone = _interopRequireDefault(require("moment-timezone"));
var _number_formatter = require("./number_formatter");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DefaultDateTimeZone = 'UTC';
const DefaultDateFormat = 'YYYY-MM-DD hh:mma';
function getMustacheLambdas(logger) {
  return getLambdas(logger);
}
const TimeZoneSet = new Set(_momentTimezone.default.tz.names());
function getLambdas(logger) {
  return {
    EvalMath: () =>
    // mustache invokes lamdas with `this` set to the current "view" (variables)
    function (text, render) {
      return evalMath(this, render(text.trim()), logger);
    },
    ParseHjson: () => function (text, render) {
      return parseHjson(render(text.trim()), logger);
    },
    FormatDate: () => function (text, render) {
      const dateString = render(text.trim()).trim();
      return formatDate(dateString, logger);
    },
    FormatNumber: () => function (text, render) {
      const numberString = render(text.trim()).trim();
      return (0, _number_formatter.formatNumber)(logger, numberString);
    }
  };
}
function evalMath(vars, o, logger) {
  const expr = `${o}`;
  try {
    const result = tinymath.evaluate(expr, vars);
    return `${result}`;
  } catch (err) {
    return logAndReturnErr(logger, `error evaluating tinymath expression "${expr}": ${err.message}`);
  }
}
function parseHjson(o, logger) {
  const hjsonObject = `${o}`;
  let object;
  try {
    object = (0, _hjson.parse)(hjsonObject);
  } catch (err) {
    return logAndReturnErr(logger, `error parsing Hjson "${hjsonObject}": ${err.message}`);
  }
  return JSON.stringify(object);
}
function formatDate(dateString, logger) {
  const {
    date,
    timeZone,
    format
  } = splitDateString(`${dateString}`);
  if (date === '') {
    return logAndReturnErr(logger, `date is empty`);
  }
  if (isNaN(new Date(date).valueOf())) {
    return logAndReturnErr(logger, `invalid date "${date}"`);
  }
  let mDate;
  try {
    mDate = (0, _momentTimezone.default)(date);
    if (!mDate.isValid()) {
      return logAndReturnErr(logger, `invalid date "${date}"`);
    }
  } catch (err) {
    return logAndReturnErr(logger, `error evaluating moment date "${date}": ${err.message}`);
  }
  if (!TimeZoneSet.has(timeZone)) {
    return logAndReturnErr(logger, `unknown timeZone value "${timeZone}"`);
  }
  try {
    mDate.tz(timeZone);
  } catch (err) {
    return logAndReturnErr(logger, `error evaluating moment timeZone "${timeZone}": ${err.message}`);
  }
  try {
    return mDate.format(format);
  } catch (err) {
    return logAndReturnErr(logger, `error evaluating moment format "${format}": ${err.message}`);
  }
}
function splitDateString(dateString) {
  const parts = dateString.split(';', 3).map(s => s.trim());
  const [date = '', timeZone = '', format = ''] = parts;
  return {
    date,
    timeZone: timeZone || DefaultDateTimeZone,
    format: format || DefaultDateFormat
  };
}
function logAndReturnErr(logger, errMessage) {
  logger.warn(`mustache render error: ${errMessage}`);
  return errMessage;
}