"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiTreeViewItemStyles = void 0;
var _react = require("@emotion/react");
var _services = require("../../services");
var _global_styling = require("../../global_styling");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
                                                                                                                                                                                                                                                                                           * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                           * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                           * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                           * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                           * Side Public License, v 1.
                                                                                                                                                                                                                                                                                           */
var _ref = process.env.NODE_ENV === "production" ? {
  name: "22lgun-euiTreeView__node",
  styles: "list-style:none;label:euiTreeView__node;"
} : {
  name: "22lgun-euiTreeView__node",
  styles: "list-style:none;label:euiTreeView__node;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiTreeViewItemStyles = function euiTreeViewItemStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var defaultSize = euiTheme.size.xl;
  var compressedSize = euiTheme.size.l;
  return {
    li: {
      euiTreeView__node: _ref,
      default: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('max-height', defaultSize), " line-height:", defaultSize, ";;label:default;"),
      compressed: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('max-height', compressedSize), " line-height:", compressedSize, ";;label:compressed;"),
      expanded: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('max-height', '100vh'), ";;label:expanded;")
    },
    button: {
      euiTreeView__nodeInner: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('width', '100%'), " ", (0, _global_styling.logicalCSS)('padding-left', euiTheme.size.s), " ", (0, _global_styling.logicalCSS)('padding-right', euiTheme.size.xxs), " display:flex;align-items:center;&:focus{", (0, _global_styling.euiFocusRing)(euiThemeContext, 'inset'), ";}&:hover,&:active,&:focus{background-color:", (0, _services.transparentize)(euiTheme.colors.text, euiTheme.focus.transparency), ";};label:euiTreeView__nodeInner;"),
      default: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('height', defaultSize), " gap:", euiTheme.size.s, ";border-radius:", euiTheme.border.radius.medium, ";;label:default;"),
      compressed: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('height', compressedSize), " gap:", euiTheme.size.xs, ";border-radius:", euiTheme.border.radius.small, ";;label:compressed;")
    },
    icon: {
      euiTreeView__iconWrapper: /*#__PURE__*/(0, _react.css)("flex-shrink:0;line-height:0;&>*{", (0, _global_styling.logicalCSS)('max-width', '100%'), ";}&>.euiToken{", (0, _global_styling.logicalCSS)('max-height', '100%'), " ", (0, _global_styling.logicalCSS)('height', 'auto'), " svg{", (0, _global_styling.logicalCSS)('width', '100%'), ";}};label:euiTreeView__iconWrapper;"),
      default: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('width', (0, _global_styling.mathWithUnits)(defaultSize, function (x) {
        return x / 2;
      })), ";;label:default;"),
      compressed: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('width', (0, _global_styling.mathWithUnits)(compressedSize, function (x) {
        return x / 2;
      })), ";;label:compressed;")
    }
  };
};
exports.euiTreeViewItemStyles = euiTreeViewItemStyles;