"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiTitleStyles = exports.euiTitle = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
                                                                                                                                                                                                                                                                                           * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                           * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                           * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                           * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                           * Side Public License, v 1.
                                                                                                                                                                                                                                                                                           */
/**
 * Mixin
 */

var euiTitle = function euiTitle(euiThemeContext) {
  var scale = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'm';
  var options = arguments.length > 2 ? arguments[2] : undefined;
  var euiTheme = euiThemeContext.euiTheme;
  var titleScaleToFontSizeScaleMap = {
    xxxs: 'xs',
    xxs: 's',
    xs: 'm',
    s: 'l',
    m: 'xl',
    l: 'xxl'
  };
  return _objectSpread(_objectSpread({}, (0, _global_styling.euiFontSize)(euiThemeContext, titleScaleToFontSizeScaleMap[scale], options)), {}, {
    fontWeight: euiTheme.font.weight[euiTheme.font.title.weight],
    color: euiTheme.colors.title
  });
};

/**
 * Styles
 */
exports.euiTitle = euiTitle;
var _ref = process.env.NODE_ENV === "production" ? {
  name: "1x2qsb1-uppercase",
  styles: "text-transform:uppercase;label:uppercase;"
} : {
  name: "1x2qsb1-uppercase",
  styles: "text-transform:uppercase;label:uppercase;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiTitleStyles = function euiTitleStyles(euiThemeContext) {
  return {
    euiTitle: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiTextBreakWord)(), " &+&{", (0, _global_styling.logicalCSS)('margin-top', euiThemeContext.euiTheme.size.l), ";};label:euiTitle;"),
    uppercase: _ref,
    // Sizes
    xxxs: /*#__PURE__*/(0, _react.css)(euiTitle(euiThemeContext, 'xxxs'), ";;label:xxxs;"),
    xxs: /*#__PURE__*/(0, _react.css)(euiTitle(euiThemeContext, 'xxs'), ";;label:xxs;"),
    xs: /*#__PURE__*/(0, _react.css)(euiTitle(euiThemeContext, 'xs'), ";;label:xs;"),
    s: /*#__PURE__*/(0, _react.css)(euiTitle(euiThemeContext, 's'), ";;label:s;"),
    m: /*#__PURE__*/(0, _react.css)(euiTitle(euiThemeContext, 'm'), ";;label:m;"),
    l: /*#__PURE__*/(0, _react.css)(euiTitle(euiThemeContext, 'l'), ";;label:l;")
  };
};
exports.euiTitleStyles = euiTitleStyles;