"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiStepHorizontalTitleStyles = exports.euiStepHorizontalStyles = exports.euiStepHorizontalNumberStyles = void 0;
var _react = require("@emotion/react");
var _services = require("../../services");
var _global_styling = require("../../global_styling/");
var _title = require("../title/title.styles");
var _step = require("./step.styles");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
                                                                                                                                                                                                                                                                                           * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                           * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                           * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                           * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                           * Side Public License, v 1.
                                                                                                                                                                                                                                                                                           */
var _ref = process.env.NODE_ENV === "production" ? {
  name: "b86pnw-disabled",
  styles: "cursor:not-allowed;label:disabled;"
} : {
  name: "b86pnw-disabled",
  styles: "cursor:not-allowed;label:disabled;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiStepHorizontalStyles = function euiStepHorizontalStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var euiStep = (0, _step.euiStepVariables)(euiTheme);

  /**
   * 1. Ensure the connecting lines stays behind the number
   * 2. Make the content of each step align to the top, even if the steps are of varying heights,
   *    e.g. due to some of their titles wrapping to multiple lines
   */

  var _generateStepSizeAndInset = function _generateStepSizeAndInset(stepNumberSize) {
    return /*#__PURE__*/(0, _react.css)("&::before,&::after{inline-size:calc(50% - (", stepNumberSize, " / 2));inset-block-start:", (0, _global_styling.mathWithUnits)([euiTheme.size.l, stepNumberSize], function (x, y) {
      return x + y / 2;
    }), ";}");
  };
  return {
    euiStepHorizontal: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalShorthandCSS)('padding', "".concat(euiTheme.size.l, " ").concat(euiTheme.size.base, " ").concat(euiTheme.size.base)), " display:flex;flex-direction:column;align-items:center;justify-content:flex-start;cursor:pointer;position:relative;inline-size:100%;&::before,&::after{content:'';position:absolute;background-color:", euiTheme.border.color, ";block-size:", euiTheme.border.width.thick, ";z-index:", euiTheme.levels.content, ";}&::before{inset-inline-start:0;}&::after{inset-inline-end:0;};label:euiStepHorizontal;"),
    // Adjust the size of the step number and connecting lines based on size
    m: _generateStepSizeAndInset(euiStep.numberSize),
    s: _generateStepSizeAndInset(euiStep.numberXSSize),
    // Note: these selectors must be nested because focus/hover state
    // is on the parent container, but affects specific children
    enabled: /*#__PURE__*/(0, _react.css)("&:focus,&:hover{.euiStepHorizontal__title{text-decoration:underline;}}&:focus{outline:none;.euiStepHorizontal__number{", (0, _global_styling.euiFocusRing)(euiThemeContext), ";}.euiStepHorizontal__number:not(:focus-visible){outline:", euiTheme.focus.width, " solid ", euiTheme.colors.darkestShade, ";}};label:enabled;"),
    disabled: _ref
  };
};
exports.euiStepHorizontalStyles = euiStepHorizontalStyles;
var euiStepHorizontalNumberStyles = function euiStepHorizontalNumberStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiStepHorizontal__number: /*#__PURE__*/(0, _react.css)("position:relative;z-index:", Number(euiTheme.levels.content) + 1, ";", _global_styling.euiCanAnimate, "{transition:all ", euiTheme.animation.fast, " ease-in-out;};label:euiStepHorizontal__number;")
  };
};
exports.euiStepHorizontalNumberStyles = euiStepHorizontalNumberStyles;
var euiStepHorizontalTitleStyles = function euiStepHorizontalTitleStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiStepHorizontal__title: /*#__PURE__*/(0, _react.css)((0, _title.euiTitle)(euiThemeContext, 'xs'), " margin-block-start:", euiTheme.size.s, ";font-weight:", euiTheme.font.weight.bold, ";text-align:center;", (0, _global_styling.euiBreakpoint)(euiThemeContext, ['xs', 's']), "{display:none;};label:euiStepHorizontal__title;"),
    disabled: /*#__PURE__*/(0, _react.css)("color:", (0, _services.makeHighContrastColor)(euiTheme.colors.disabledText)(euiTheme.colors.body), ";;label:disabled;")
  };
};
exports.euiStepHorizontalTitleStyles = euiStepHorizontalTitleStyles;