"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiSideNavHeading = void 0;
var _react = require("@emotion/react");
var _react2 = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _title = require("../title");
var _accessibility = require("../accessibility");
var _excluded = ["children", "id", "className", "element", "screenReaderOnly", "size", "textTransform"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
var EuiSideNavHeading = function EuiSideNavHeading(_ref) {
  var children = _ref.children,
    id = _ref.id,
    className = _ref.className,
    _ref$element = _ref.element,
    HeadingElement = _ref$element === void 0 ? 'h2' : _ref$element,
    _ref$screenReaderOnly = _ref.screenReaderOnly,
    screenReaderOnly = _ref$screenReaderOnly === void 0 ? false : _ref$screenReaderOnly,
    _ref$size = _ref.size,
    size = _ref$size === void 0 ? 'xs' : _ref$size,
    textTransform = _ref.textTransform,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = (0, _classnames.default)('euiSideNav__heading', className);
  var _useEuiTheme = (0, _services.useEuiTheme)(),
    euiTheme = _useEuiTheme.euiTheme;
  return screenReaderOnly ? (0, _react.jsx)(_accessibility.EuiScreenReaderOnly, null, (0, _react.jsx)(HeadingElement, _extends({
    id: id,
    className: classes
  }, rest), children)) : (0, _react.jsx)(_title.EuiTitle, {
    size: size,
    textTransform: textTransform
  }, (0, _react.jsx)(HeadingElement, _extends({
    id: id,
    className: classes,
    css: /*#__PURE__*/(0, _react.css)({
      marginBlockEnd: euiTheme.size.l
    }, ";label:EuiSideNavHeading;")
  }, rest), children));
};
exports.EuiSideNavHeading = EuiSideNavHeading;
EuiSideNavHeading.propTypes = {
  children: _propTypes.default.node.isRequired,
  /**
     * The actual HTML heading element to wrap the `heading`.
     * Default is `h2`
     */
  element: _propTypes.default.oneOf(["h1", "h2", "h3", "h4", "h5", "h6", "span"]),
  /**
     * For best accessibility, `<nav>` elements should have a nested heading. But you can hide this element if it's redundent from something else (except on mobile).
     */
  screenReaderOnly: _propTypes.default.bool
};