"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.openAnimationTiming = exports.euiPopoverPanelStyles = void 0;
var _react = require("@emotion/react");
var _mixins = require("../../../themes/amsterdam/global_styling/mixins");
var _functions = require("../../../themes/amsterdam/global_styling/functions");
var _services = require("../../../services");
var _global_styling = require("../../../global_styling");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
                                                                                                                                                                                                                                                                                           * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                           * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                           * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                           * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                           * Side Public License, v 1.
                                                                                                                                                                                                                                                                                           */
var openAnimationTiming = 'slow';

/**
 * 1. Can expand further, but it looks weird if it's smaller than the originating button.
 * 2. Animation happens on the panel. But don't animate position when using the attached mode like for inputs
 * 3. Make sure the panel stays within the window.
 * 4. Make the popover lighter on dark mode (too hard to distinguish from plain bgs otherwise), and set a CSS var for the arrow to use
 */
exports.openAnimationTiming = openAnimationTiming;
var _ref = process.env.NODE_ENV === "production" ? {
  name: "j5y6yx-isOpen",
  styles: "opacity:1;pointer-events:auto;label:isOpen;"
} : {
  name: "j5y6yx-isOpen",
  styles: "opacity:1;pointer-events:auto;label:isOpen;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiPopoverPanelStyles = function euiPopoverPanelStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme,
    colorMode = euiThemeContext.colorMode;
  var translateDistance = euiTheme.size.s;
  var animationSpeed = euiTheme.animation[openAnimationTiming];
  var opacityTransition = "opacity ".concat(euiTheme.animation.bounce, " ").concat(animationSpeed);
  var transformTransition = "transform ".concat(euiTheme.animation.bounce, " ").concat((0, _global_styling.mathWithUnits)(animationSpeed, function (x) {
    return x + 100;
  }));
  return {
    // Base
    euiPopover__panel: /*#__PURE__*/(0, _react.css)("position:absolute;", (0, _global_styling.logicalCSS)('min-width', "".concat(euiTheme.base * 7, "px")), (0, _global_styling.logicalCSS)('max-width', "calc(100vw - ".concat(euiTheme.size.xl, ")")), "backface-visibility:hidden;pointer-events:none;opacity:0;background-color:var(--euiPopoverBackgroundColor);", _global_styling.euiCanAnimate, "{transition:", opacityTransition, ",", transformTransition, ";}&:focus{outline-offset:0;};label:euiPopover__panel;"),
    isOpen: _ref,
    /* 4 */
    light: /*#__PURE__*/(0, _react.css)("--euiPopoverBackgroundColor:", euiTheme.colors.emptyShade, ";;label:light;"),
    dark: /*#__PURE__*/(0, _react.css)("--euiPopoverBackgroundColor:", (0, _services.tint)(euiTheme.colors.emptyShade, 0.025), ";;label:dark;"),
    // Regular popover with an arrow, a transform animation/transition, and a
    // drop shadow via `filter` (which automatically handles the arrow)
    hasTransform: {
      hasTransform: /*#__PURE__*/(0, _react.css)("transform:translateY(0) translateX(0) translateZ(0);", (0, _mixins.euiShadowMedium)(euiThemeContext, {
        property: 'filter'
      }), " ", _global_styling.euiCanAnimate, "{transition:", opacityTransition, ",", transformTransition, ";};label:hasTransform;"),
      // Positions
      top: /*#__PURE__*/(0, _react.css)("transform:translateY(", translateDistance, ") translateZ(0);;label:top;"),
      bottom: /*#__PURE__*/(0, _react.css)("transform:translateY(-", translateDistance, ") translateZ(0);;label:bottom;"),
      left: /*#__PURE__*/(0, _react.css)("transform:translateX(", translateDistance, ") translateZ(0);;label:left;"),
      right: /*#__PURE__*/(0, _react.css)("transform:translateX(-", translateDistance, ") translateZ(0);;label:right;")
    },
    // No arrow, transform, or filters
    isAttached: {
      isAttached: /*#__PURE__*/(0, _react.css)(_global_styling.euiCanAnimate, "{transition:", opacityTransition, ";};label:isAttached;"),
      top: /*#__PURE__*/(0, _react.css)((0, _mixins.euiShadowFlat)(euiThemeContext), ";;label:top;"),
      bottom: /*#__PURE__*/(0, _react.css)((0, _mixins.euiShadow)(euiThemeContext, 'm'), ";;label:bottom;"),
      get left() {
        return this.bottom;
      },
      get right() {
        return this.bottom;
      }
    },
    // Has an arrow, but cannot have transform or filter CSS - they create a
    // stacking context that messes up the drag/drop fixed positioning
    hasDragDrop: {
      hasDragDrop: /*#__PURE__*/(0, _react.css)((0, _mixins.euiShadowMedium)(euiThemeContext, {
        property: 'box-shadow'
      }), " ", _global_styling.euiCanAnimate, "{transition:", opacityTransition, ";};label:hasDragDrop;"),
      // The offset transforms must be recreated in margins
      top: /*#__PURE__*/(0, _react.css)("margin-block-start:", translateDistance, ";;label:top;"),
      bottom: /*#__PURE__*/(0, _react.css)("margin-block-start:-", translateDistance, ";.euiPopover__arrow{filter:drop-shadow(\n            0 -6px 6px ", (0, _functions.getShadowColor)(euiTheme.colors.shadow, 0.12, colorMode), "\n          );};label:bottom;"),
      left: /*#__PURE__*/(0, _react.css)("margin-inline-start:", translateDistance, ";.euiPopover__arrow{filter:drop-shadow(\n            6px 0 6px ", (0, _functions.getShadowColor)(euiTheme.colors.shadow, 0.12, colorMode), "\n          );};label:left;"),
      right: /*#__PURE__*/(0, _react.css)("margin-inline-start:-", translateDistance, ";.euiPopover__arrow{filter:drop-shadow(\n            -6px 0 6px ", (0, _functions.getShadowColor)(euiTheme.colors.shadow, 0.12, colorMode), "\n          );};label:right;")
    }
  };
};
exports.euiPopoverPanelStyles = euiPopoverPanelStyles;