"use strict";

var _react = _interopRequireDefault(require("react"));
var _button = require("../../button");
var _page_header = require("./page_header");
var _react2 = require("@emotion/react");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../../cypress/support" />

describe('EuiPageHeader', function () {
  beforeEach(function () {
    cy.viewport(1024, 768); // medium breakpoint
    cy.realMount((0, _react2.jsx)(_page_header.EuiPageHeader, {
      pageTitle: "Page title",
      iconType: "logoKibana",
      description: "This description should be describing the current page as depicted by the page title. It will never extend beneath the right side content.",
      rightSideItems: [(0, _react2.jsx)(_button.EuiButton, {
        fill: true
      }, "Add something"), (0, _react2.jsx)(_button.EuiButton, null, "Do something")]
    }));
    cy.get('h1.euiTitle').should('exist');
  });
  describe('Automated accessibility check', function () {
    it('has zero violations on first render', function () {
      cy.checkAxe();
    });
  });
});