"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDefaultEuiMarkdownParsingPlugins = exports.defaultParsingPlugins = void 0;
var _remarkParseNoTrim = _interopRequireDefault(require("remark-parse-no-trim"));
var _remarkEmoji = _interopRequireDefault(require("remark-emoji"));
var _remarkBreaks = _interopRequireDefault(require("remark-breaks"));
var _remark_prismjs = _interopRequireDefault(require("../remark/remark_prismjs"));
var MarkdownTooltip = _interopRequireWildcard(require("../markdown_tooltip"));
var MarkdownCheckbox = _interopRequireWildcard(require("../markdown_checkbox"));
var _markdown_link_validator = require("../markdown_link_validator");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// Importing seemingly unused types from `unified` because the definitions
// are exported for two versions of TypeScript (3.4, 4.0) and implicit
// imports during eui.d.ts generation default to the incorrect version (3.4).
// Explicit imports here resolve the version mismatch.

var getDefaultEuiMarkdownParsingPlugins = function getDefaultEuiMarkdownParsingPlugins() {
  var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
    exclude = _ref.exclude;
  var excludeSet = new Set(exclude);
  var parsingPlugins = [[_remarkParseNoTrim.default, {}], [_remark_prismjs.default, {}], [_remarkEmoji.default, {
    emoticon: false
  }], [_remarkBreaks.default, {}], [_markdown_link_validator.euiMarkdownLinkValidator, {
    allowRelative: true,
    allowProtocols: ['https:', 'http:', 'mailto:']
  }], [MarkdownCheckbox.parser, {}]];
  if (!excludeSet.has('tooltip')) parsingPlugins.push([MarkdownTooltip.parser, {}]);
  return parsingPlugins;
};
exports.getDefaultEuiMarkdownParsingPlugins = getDefaultEuiMarkdownParsingPlugins;
var defaultParsingPlugins = getDefaultEuiMarkdownParsingPlugins();
exports.defaultParsingPlugins = defaultParsingPlugins;