"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiMarkdownFormatStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Mixins
 */ // Internal utility for text scales/sizes
var euiScaleMarkdownFormatText = function euiScaleMarkdownFormatText(euiTheme, options) {
  var _euiFontSize = (0, _global_styling.euiFontSize)(euiTheme, 'm', options),
    fontSize = _euiFontSize.fontSize,
    lineHeight = _euiFontSize.lineHeight;
  var unit = options.unit;
  var lineHeightSize = unit === 'em' ? "".concat(lineHeight, "em") : lineHeight;

  // Custom scales
  var tablePaddingVertical = (0, _global_styling.mathWithUnits)(fontSize, function (x) {
    return x / 4;
  });
  var tablePaddingHorizontal = (0, _global_styling.mathWithUnits)(fontSize, function (x) {
    return x / 2;
  });
  return "\n    .euiCheckbox .euiCheckbox__input ~ .euiCheckbox__label { // Extra specificity necessary to override default checkbox CSS\n      font-size: ".concat(fontSize, ";\n      ").concat((0, _global_styling.logicalCSS)('padding-left', lineHeightSize), "\n      line-height: ").concat(lineHeight, ";\n    }\n\n    .euiCheckbox + *:not(.euiCheckbox) {\n      ").concat((0, _global_styling.logicalCSS)('margin-top', fontSize), "\n    }\n\n    .euiMarkdownFormat__codeblockWrapper {\n      ").concat((0, _global_styling.logicalCSS)('margin-bottom', fontSize), "\n    }\n\n    .euiMarkdownFormat__table {\n      ").concat((0, _global_styling.logicalCSS)('margin-bottom', fontSize), "\n    }\n\n    .euiMarkdownFormat__table th,\n    .euiMarkdownFormat__table td {\n      ").concat((0, _global_styling.logicalCSS)('padding-vertical', tablePaddingVertical), "\n      ").concat((0, _global_styling.logicalCSS)('padding-horizontal', tablePaddingHorizontal), "\n    }\n  ");
};

/**
 * Styles
 */
var euiMarkdownFormatStyles = function euiMarkdownFormatStyles(euiTheme) {
  return {
    // TODO: Remaining _markdown_format.scss styles
    euiMarkdownFormat: /*#__PURE__*/(0, _react.css)(";label:euiMarkdownFormat;"),
    // Text sizes
    m: /*#__PURE__*/(0, _react.css)(euiScaleMarkdownFormatText(euiTheme, {
      customScale: 'm'
    }), ";;label:m;"),
    s: /*#__PURE__*/(0, _react.css)(euiScaleMarkdownFormatText(euiTheme, {
      customScale: 's'
    }), ";;label:s;"),
    xs: /*#__PURE__*/(0, _react.css)(euiScaleMarkdownFormatText(euiTheme, {
      customScale: 'xs'
    }), ";;label:xs;"),
    relative: /*#__PURE__*/(0, _react.css)(euiScaleMarkdownFormatText(euiTheme, {
      unit: 'em'
    }), ";;label:relative;")
  };
};
exports.euiMarkdownFormatStyles = euiMarkdownFormatStyles;