"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiMarkdownEditorToolbar = void 0;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _button = require("../button");
var _i18n = require("../i18n");
var _tool_tip = require("../tool_tip");
var _markdown_modes = require("./markdown_modes");
var _markdown_context = require("./markdown_context");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); } /*
                                                                                                                                                                                                                                                                                                                                                     * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                     * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                     * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                                                                                     * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                                                                                     * Side Public License, v 1.
                                                                                                                                                                                                                                                                                                                                                     */
var boldItalicButtons = [{
  id: 'mdBold',
  label: 'Bold',
  name: 'strong',
  iconType: 'editorBold'
}, {
  id: 'mdItalic',
  label: 'Italic',
  name: 'emphasis',
  iconType: 'editorItalic'
}];
var listButtons = [{
  id: 'mdUl',
  label: 'Unordered list',
  name: 'ul',
  iconType: 'editorUnorderedList'
}, {
  id: 'mdOl',
  label: 'Ordered list',
  name: 'ol',
  iconType: 'editorOrderedList'
}, {
  id: 'mdTl',
  label: 'Task list',
  name: 'tl',
  iconType: 'editorChecklist'
}];
var quoteCodeLinkButtons = [{
  id: 'mdQuote',
  label: 'Quote',
  name: 'quote',
  iconType: 'quote'
}, {
  id: 'mdCode',
  label: 'Code',
  name: 'inlineCode',
  iconType: 'editorCodeBlock'
}, {
  id: 'mdLink',
  label: 'Link',
  name: 'link',
  iconType: 'editorLink'
}];
var EuiMarkdownEditorToolbarButton = function EuiMarkdownEditorToolbarButton(_ref) {
  var selectedNode = _ref.selectedNode,
    handleMdButtonClick = _ref.handleMdButtonClick,
    isEditable = _ref.isEditable,
    isDisabled = _ref.isDisabled,
    id = _ref.id,
    nodeId = _ref.nodeId,
    label = _ref.label,
    icon = _ref.icon;
  var isSelected = selectedNode && selectedNode.type === nodeId;
  return (0, _react2.jsx)(_button.EuiButtonIcon, _extends({
    color: "text"
  }, isSelected ? {
    style: {
      background: 'rgba(0, 0, 0, 0.15)'
    }
  } : null, {
    "data-test-subj": "euiMarkdownEditorToolbarButton".concat(isSelected ? ' pressed' : ''),
    onClick: function onClick() {
      return handleMdButtonClick(id);
    },
    iconType: icon,
    "aria-label": label,
    isDisabled: !isEditable || isDisabled
  }));
};
var EuiMarkdownEditorToolbar = /*#__PURE__*/(0, _react.forwardRef)(function (_ref2, ref) {
  var markdownActions = _ref2.markdownActions,
    viewMode = _ref2.viewMode,
    onClickPreview = _ref2.onClickPreview,
    uiPlugins = _ref2.uiPlugins,
    selectedNode = _ref2.selectedNode;
  var _useContext = (0, _react.useContext)(_markdown_context.EuiMarkdownContext),
    openPluginEditor = _useContext.openPluginEditor,
    readOnly = _useContext.readOnly;
  var handleMdButtonClick = function handleMdButtonClick(mdButtonId) {
    var actionResult = markdownActions.do(mdButtonId);
    if (actionResult !== true) openPluginEditor(actionResult);
  };
  var isPreviewing = viewMode === _markdown_modes.MODE_VIEWING;
  var isEditable = !isPreviewing && !readOnly;
  return (0, _react2.jsx)("div", {
    ref: ref,
    "data-test-subj": "euiMarkdownEditorToolbar",
    className: "euiMarkdownEditorToolbar"
  }, (0, _react2.jsx)("div", {
    className: "euiMarkdownEditorToolbar__buttons"
  }, boldItalicButtons.map(function (item) {
    return (0, _react2.jsx)(_tool_tip.EuiToolTip, {
      key: item.id,
      content: item.label,
      delay: "long"
    }, (0, _react2.jsx)(EuiMarkdownEditorToolbarButton, {
      selectedNode: selectedNode,
      handleMdButtonClick: handleMdButtonClick,
      isEditable: isEditable,
      id: item.id,
      nodeId: item.name,
      label: item.label,
      icon: item.iconType
    }));
  }), (0, _react2.jsx)("span", {
    className: "euiMarkdownEditorToolbar__divider"
  }), listButtons.map(function (item) {
    return (0, _react2.jsx)(_tool_tip.EuiToolTip, {
      key: item.id,
      content: item.label,
      delay: "long"
    }, (0, _react2.jsx)(EuiMarkdownEditorToolbarButton, {
      selectedNode: selectedNode,
      handleMdButtonClick: handleMdButtonClick,
      isEditable: isEditable,
      id: item.id,
      nodeId: item.name,
      label: item.label,
      icon: item.iconType
    }));
  }), (0, _react2.jsx)("span", {
    className: "euiMarkdownEditorToolbar__divider"
  }), quoteCodeLinkButtons.map(function (item) {
    return (0, _react2.jsx)(_tool_tip.EuiToolTip, {
      key: item.id,
      content: item.label,
      delay: "long"
    }, (0, _react2.jsx)(EuiMarkdownEditorToolbarButton, {
      selectedNode: selectedNode,
      handleMdButtonClick: handleMdButtonClick,
      isEditable: isEditable,
      id: item.id,
      nodeId: item.name,
      label: item.label,
      icon: item.iconType
    }));
  }), uiPlugins.length > 0 ? (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)("span", {
    className: "euiMarkdownEditorToolbar__divider"
  }), uiPlugins.map(function (_ref3) {
    var name = _ref3.name,
      button = _ref3.button;
    return (0, _react2.jsx)(_tool_tip.EuiToolTip, {
      key: name,
      content: button.label,
      delay: "long"
    }, (0, _react2.jsx)(EuiMarkdownEditorToolbarButton, {
      selectedNode: selectedNode,
      handleMdButtonClick: handleMdButtonClick,
      isEditable: isEditable,
      isDisabled: button.isDisabled,
      id: name,
      nodeId: name,
      label: button.label,
      icon: button.iconType
    }));
  })) : null), isPreviewing ? (0, _react2.jsx)(_button.EuiButtonEmpty, {
    "data-test-subj": "markdown_editor_edit_button",
    iconType: "editorCodeBlock",
    color: "text",
    size: "s",
    onClick: onClickPreview,
    isDisabled: readOnly
  }, (0, _react2.jsx)(_i18n.EuiI18n, {
    token: "euiMarkdownEditorToolbar.editor",
    default: "Editor"
  })) : (0, _react2.jsx)(_button.EuiButtonEmpty, {
    "data-test-subj": "markdown_editor_preview_button",
    iconType: "eye",
    color: "text",
    size: "s",
    onClick: onClickPreview,
    isDisabled: readOnly
  }, (0, _react2.jsx)(_i18n.EuiI18n, {
    token: "euiMarkdownEditorToolbar.previewMarkdown",
    default: "Preview"
  })));
});
exports.EuiMarkdownEditorToolbar = EuiMarkdownEditorToolbar;
EuiMarkdownEditorToolbar.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  selectedNode: _propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.any.isRequired]),
  markdownActions: _propTypes.default.any.isRequired,
  viewMode: _propTypes.default.oneOfType([_propTypes.default.any.isRequired, _propTypes.default.any.isRequired]).isRequired,
  onClickPreview: _propTypes.default.func.isRequired,
  uiPlugins: _propTypes.default.arrayOf(_propTypes.default.shape({
    name: _propTypes.default.string.isRequired,
    button: _propTypes.default.shape({
      label: _propTypes.default.string.isRequired,
      iconType: _propTypes.default.oneOfType([_propTypes.default.oneOf(["accessibility", "addDataApp", "advancedSettingsApp", "agentApp", "aggregate", "analyzeEvent", "annotation", "apmApp", "apmTrace", "appSearchApp", "apps", "arrowDown", "arrowLeft", "arrowRight", "arrowUp", "arrowStart", "arrowEnd", "article", "asterisk", "at", "auditbeatApp", "beaker", "bell", "bellSlash", "beta", "bolt", "boxesHorizontal", "boxesVertical", "branch", "branchUser", "broom", "brush", "bug", "bullseye", "calendar", "canvasApp", "casesApp", "check", "checkInCircleFilled", "cheer", "classificationJob", "clock", "cloudDrizzle", "cloudStormy", "cloudSunny", "cluster", "codeApp", "color", "compute", "console", "consoleApp", "container", "continuityAbove", "continuityAboveBelow", "continuityBelow", "continuityWithin", "controlsHorizontal", "controlsVertical", "copy", "copyClipboard", "createAdvancedJob", "createMultiMetricJob", "createPopulationJob", "createSingleMetricJob", "cross", "crossClusterReplicationApp", "crosshairs", "currency", "cut", "dashboardApp", "dataVisualizer", "database", "desktop", "devToolsApp", "diff", "discoverApp", "discuss", "document", "documentEdit", "documentation", "documents", "dot", "dotInCircle", "doubleArrowLeft", "doubleArrowRight", "download", "editorAlignCenter", "editorAlignLeft", "editorAlignRight", "editorBold", "editorChecklist", "editorCodeBlock", "editorComment", "editorDistributeHorizontal", "editorDistributeVertical", "editorHeading", "editorItalic", "editorItemAlignBottom", "editorItemAlignCenter", "editorItemAlignLeft", "editorItemAlignMiddle", "editorItemAlignRight", "editorItemAlignTop", "editorLink", "editorOrderedList", "editorPositionBottomLeft", "editorPositionBottomRight", "editorPositionTopLeft", "editorPositionTopRight", "editorRedo", "editorStrike", "editorTable", "editorUnderline", "editorUndo", "editorUnorderedList", "email", "empty", "emsApp", "endpoint", "eql", "eraser", "error", "esqlVis", "exit", "expand", "expandMini", "exportAction", "eye", "eyeClosed", "faceHappy", "faceNeutral", "faceSad", "filebeatApp", "filter", "filterExclude", "filterIgnore", "filterInclude", "filterInCircle", "flag", "fleetApp", "fold", "folderCheck", "folderClosed", "folderExclamation", "folderOpen", "frameNext", "framePrevious", "fullScreen", "fullScreenExit", "function", "gear", "gisApp", "glasses", "globe", "grab", "grabHorizontal", "grabOmnidirectional", "gradient", "graphApp", "grid", "grokApp", "heart", "heartbeatApp", "heatmap", "help", "home", "iInCircle", "image", "importAction", "index", "indexClose", "indexEdit", "indexFlush", "indexManagementApp", "indexMapping", "indexOpen", "indexPatternApp", "indexRollupApp", "indexRuntime", "indexSettings", "indexTemporary", "infinity", "inputOutput", "inspect", "invert", "ip", "key", "keyboard", "kqlField", "kqlFunction", "kqlOperand", "kqlSelector", "kqlValue", "kubernetesNode", "kubernetesPod", "launch", "layers", "lensApp", "lettering", "lineDashed", "lineDotted", "lineSolid", "link", "list", "listAdd", "lock", "lockOpen", "logoAWS", "logoAWSMono", "logoAerospike", "logoApache", "logoAppSearch", "logoAzure", "logoAzureMono", "logoBeats", "logoBusinessAnalytics", "logoCeph", "logoCloud", "logoCloudEnterprise", "logoCode", "logoCodesandbox", "logoCouchbase", "logoDocker", "logoDropwizard", "logoElastic", "logoElasticStack", "logoElasticsearch", "logoEnterpriseSearch", "logoEtcd", "logoGCP", "logoGCPMono", "logoGithub", "logoGmail", "logoGolang", "logoGoogleG", "logoHAproxy", "logoIBM", "logoIBMMono", "logoKafka", "logoKibana", "logoKubernetes", "logoLogging", "logoLogstash", "logoMaps", "logoMemcached", "logoMetrics", "logoMongodb", "logoMySQL", "logoNginx", "logoObservability", "logoOsquery", "logoPhp", "logoPostgres", "logoPrometheus", "logoRabbitmq", "logoRedis", "logoSecurity", "logoSiteSearch", "logoSketch", "logoSlack", "logoUptime", "logoVulnerabilityManagement", "logoWebhook", "logoWindows", "logoWorkplaceSearch", "logsApp", "logstashFilter", "logstashIf", "logstashInput", "logstashOutput", "logstashQueue", "machineLearningApp", "magnet", "magnifyWithExclamation", "magnifyWithMinus", "magnifyWithPlus", "managementApp", "mapMarker", "memory", "menu", "menuDown", "menuLeft", "menuRight", "menuUp", "merge", "metricbeatApp", "metricsApp", "minimize", "minus", "minusInCircle", "minusInCircleFilled", "mobile", "monitoringApp", "moon", "namespace", "nested", "newChat", "node", "notebookApp", "number", "offline", "online", "outlierDetectionJob", "package", "packetbeatApp", "pageSelect", "pagesSelect", "palette", "paperClip", "partial", "pause", "payment", "pencil", "percent", "pin", "pinFilled", "pipeBreaks", "pipelineApp", "pipeNoBreaks", "pivot", "play", "playFilled", "plus", "plusInCircle", "plusInCircleFilled", "popout", "push", "questionInCircle", "quote", "recentlyViewedApp", "refresh", "regressionJob", "reporter", "reportingApp", "returnKey", "save", "savedObjectsApp", "scale", "search", "searchProfilerApp", "securityAnalyticsApp", "securityApp", "securitySignal", "securitySignalDetected", "securitySignalResolved", "sessionViewer", "shard", "share", "snowflake", "sortAscending", "sortDescending", "sortDown", "sortLeft", "sortRight", "sortUp", "sortable", "spaces", "spacesApp", "sparkles", "sqlApp", "starEmpty", "starEmptySpace", "starFilled", "starFilledSpace", "starMinusEmpty", "starMinusFilled", "starPlusEmpty", "starPlusFilled", "stats", "stop", "stopFilled", "stopSlash", "storage", "string", "submodule", "sun", "swatchInput", "symlink", "tableDensityCompact", "tableDensityExpanded", "tableDensityNormal", "tableOfContents", "tag", "tear", "temperature", "timeline", "timelineWithArrow", "timelionApp", "timeRefresh", "timeslider", "training", "transitionLeftIn", "transitionLeftOut", "transitionTopIn", "transitionTopOut", "trash", "unfold", "unlink", "upgradeAssistantApp", "uptimeApp", "user", "userAvatar", "users", "usersRolesApp", "vector", "videoPlayer", "visArea", "visAreaStacked", "visBarHorizontal", "visBarHorizontalStacked", "visBarVertical", "visBarVerticalStacked", "visGauge", "visGoal", "visLine", "visMapCoordinate", "visMapRegion", "visMetric", "visPie", "visTable", "visTagCloud", "visText", "visTimelion", "visVega", "visVisualBuilder", "visualizeApp", "vulnerabilityManagementApp", "warning", "alert", "watchesApp", "wordWrap", "wordWrapDisabled", "workplaceSearchApp", "wrench", "tokenAlias", "tokenAnnotation", "tokenArray", "tokenBinary", "tokenBoolean", "tokenClass", "tokenCompletionSuggester", "tokenConstant", "tokenDate", "tokenElement", "tokenEnum", "tokenEnumMember", "tokenEvent", "tokenException", "tokenField", "tokenFile", "tokenFlattened", "tokenFunction", "tokenGeo", "tokenHistogram", "tokenInterface", "tokenIP", "tokenJoin", "tokenKey", "tokenKeyword", "tokenMethod", "tokenMetricCounter", "tokenMetricGauge", "tokenModule", "tokenNamespace", "tokenNested", "tokenNull", "tokenNumber", "tokenObject", "tokenOperator", "tokenPackage", "tokenParameter", "tokenPercolator", "tokenProperty", "tokenRange", "tokenRankFeature", "tokenRankFeatures", "tokenRepo", "tokenSearchType", "tokenShape", "tokenString", "tokenStruct", "tokenSymbol", "tokenTag", "tokenText", "tokenTokenCount", "tokenVariable", "tokenVectorDense", "tokenDenseVector", "tokenVectorSparse"]).isRequired, _propTypes.default.string.isRequired, _propTypes.default.elementType.isRequired]).isRequired,
      isDisabled: _propTypes.default.bool
    }).isRequired,
    helpText: _propTypes.default.node,
    formatting: _propTypes.default.shape({
      prefix: _propTypes.default.string,
      suffix: _propTypes.default.string,
      blockPrefix: _propTypes.default.string,
      blockSuffix: _propTypes.default.string,
      multiline: _propTypes.default.bool,
      replaceNext: _propTypes.default.string,
      prefixSpace: _propTypes.default.bool,
      scanFor: _propTypes.default.string,
      surroundWithNewlines: _propTypes.default.bool,
      orderedList: _propTypes.default.bool,
      trimFirst: _propTypes.default.bool
    }),
    editor: _propTypes.default.elementType
  }).isRequired).isRequired
};
EuiMarkdownEditorToolbar.displayName = 'EuiMarkdownEditorToolbar';