"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SIZES = exports.EuiLoadingChart = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _loading_strings = require("./_loading_strings");
var _loading_chart = require("./loading_chart.styles");
var _react2 = require("@emotion/react");
var _excluded = ["size", "mono", "className", "aria-label"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
var SIZES = ['m', 'l', 'xl'];
exports.SIZES = SIZES;
var EuiLoadingChart = function EuiLoadingChart(_ref) {
  var _ref$size = _ref.size,
    size = _ref$size === void 0 ? 'm' : _ref$size,
    _ref$mono = _ref.mono,
    mono = _ref$mono === void 0 ? false : _ref$mono,
    className = _ref.className,
    ariaLabel = _ref['aria-label'],
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = (0, _classnames.default)('euiLoadingChart', className);
  var styles = (0, _services.useEuiMemoizedStyles)(_loading_chart.euiLoadingChartStyles);
  var cssStyles = [styles.euiLoadingChart, styles[size]];
  var barStyles = (0, _services.useEuiMemoizedStyles)(_loading_chart.euiLoadingChartBarStyles);
  var barCssStyles = [barStyles.euiLoadingChart__bar, mono ? barStyles.mono : barStyles.nonmono, barStyles[size]];
  var defaultAriaLabel = (0, _loading_strings.useLoadingAriaLabel)();
  return (0, _react2.jsx)("span", _extends({
    className: classes,
    css: cssStyles,
    role: "progressbar",
    "aria-label": ariaLabel || defaultAriaLabel
  }, rest), Array.from({
    length: _loading_chart.BARS_COUNT
  }, function (_, index) {
    return (0, _react2.jsx)("span", {
      key: index,
      css: barCssStyles
    });
  }));
};
exports.EuiLoadingChart = EuiLoadingChart;
EuiLoadingChart.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  size: _propTypes.default.any,
  mono: _propTypes.default.bool
};