"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
var _react = _interopRequireWildcard(require("react"));
var _key_pad_menu = require("./key_pad_menu");
var _key_pad_menu_item = require("./key_pad_menu_item");
var _icon = require("../icon");
var _services = require("../../services");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(arr, i) { var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"]; if (null != _i) { var _s, _e, _x, _r, _arr = [], _n = !0, _d = !1; try { if (_x = (_i = _i.call(arr)).next, 0 === i) { if (Object(_i) !== _i) return; _n = !1; } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0); } catch (err) { _d = !0, _e = err; } finally { try { if (!_n && null != _i.return && (_r = _i.return(), Object(_r) !== _r)) return; } finally { if (_d) throw _e; } } return _arr; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; } /*
                                                                       * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                       * or more contributor license agreements. Licensed under the Elastic License
                                                                       * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                       * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                       * Side Public License, v 1.
                                                                       */ /// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../cypress/support" />
var KeyPadMenu = function KeyPadMenu() {
  var keypadButtonId__1 = (0, _services.useGeneratedHtmlId)({
    prefix: 'keypadButton',
    suffix: 'first'
  });
  var keypadButtonId__2 = (0, _services.useGeneratedHtmlId)({
    prefix: 'keypadButton',
    suffix: 'second'
  });
  var keypadButtonId__3 = (0, _services.useGeneratedHtmlId)({
    prefix: 'keypadButton',
    suffix: 'third'
  });
  var keypadButtonId__4 = (0, _services.useGeneratedHtmlId)({
    prefix: 'keypadButton',
    suffix: 'fourth'
  });
  var keypadButtonId__5 = (0, _services.useGeneratedHtmlId)({
    prefix: 'keypadButton',
    suffix: 'fifth'
  });
  var keypadButtonId__6 = (0, _services.useGeneratedHtmlId)({
    prefix: 'keypadButton',
    suffix: 'sixth'
  });
  var _useState = (0, _react.useState)(keypadButtonId__6),
    _useState2 = _slicedToArray(_useState, 2),
    selectedID = _useState2[0],
    setSelectedID = _useState2[1];
  return (0, _react2.jsx)("div", {
    "aria-label": "Menu keypad"
  }, (0, _react2.jsx)(_key_pad_menu.EuiKeyPadMenu, null, (0, _react2.jsx)(_key_pad_menu_item.EuiKeyPadMenuItem, {
    "data-test-subj": "cy-keypad-button-1",
    id: keypadButtonId__1,
    label: "Button 1",
    isSelected: selectedID === keypadButtonId__1,
    onClick: function onClick() {
      return setSelectedID(keypadButtonId__1);
    }
  }, (0, _react2.jsx)(_icon.EuiIcon, {
    type: "grid",
    size: "l"
  })), (0, _react2.jsx)(_key_pad_menu_item.EuiKeyPadMenuItem, {
    "data-test-subj": "cy-keypad-button-2",
    id: keypadButtonId__2,
    label: "Button 2",
    isSelected: selectedID === keypadButtonId__2,
    onClick: function onClick() {
      return setSelectedID(keypadButtonId__2);
    }
  }, (0, _react2.jsx)(_icon.EuiIcon, {
    type: "grid",
    size: "l"
  })), (0, _react2.jsx)(_key_pad_menu_item.EuiKeyPadMenuItem, {
    "data-test-subj": "cy-keypad-button-3",
    id: keypadButtonId__3,
    label: "Button 3",
    isSelected: selectedID === keypadButtonId__3,
    onClick: function onClick() {
      return setSelectedID(keypadButtonId__3);
    }
  }, (0, _react2.jsx)(_icon.EuiIcon, {
    type: "grid",
    size: "l"
  })), (0, _react2.jsx)(_key_pad_menu_item.EuiKeyPadMenuItem, {
    "data-test-subj": "cy-keypad-link-1",
    id: keypadButtonId__4,
    label: "Link 1",
    href: "#/navigation/key-pad-menu",
    isSelected: selectedID === keypadButtonId__4,
    onClick: function onClick() {
      return setSelectedID(keypadButtonId__4);
    }
  }, (0, _react2.jsx)(_icon.EuiIcon, {
    type: "link",
    size: "l"
  })), (0, _react2.jsx)(_key_pad_menu_item.EuiKeyPadMenuItem, {
    "data-test-subj": "cy-keypad-link-2",
    id: keypadButtonId__5,
    label: "Link 2",
    href: "#/navigation/key-pad-menu",
    isSelected: selectedID === keypadButtonId__5,
    onClick: function onClick() {
      return setSelectedID(keypadButtonId__5);
    }
  }, (0, _react2.jsx)(_icon.EuiIcon, {
    type: "link",
    size: "l"
  })), (0, _react2.jsx)(_key_pad_menu_item.EuiKeyPadMenuItem, {
    "data-test-subj": "cy-keypad-link-3",
    id: keypadButtonId__6,
    label: "Disabled Link 3",
    isDisabled: true,
    isSelected: selectedID === keypadButtonId__6
  }, (0, _react2.jsx)(_icon.EuiIcon, {
    type: "link",
    size: "l"
  }))));
};
beforeEach(function () {
  cy.realMount((0, _react2.jsx)(KeyPadMenu, null));
  cy.get('div[aria-label="Menu keypad"]').should('exist');
});
describe('EuiKeyPadMenu', function () {
  describe('Automated accessibility check', function () {
    it('has zero violations on first render', function () {
      cy.checkAxe();
    });
    it('has zero violations on item click', function () {
      cy.get('a[data-test-subj="cy-keypad-link-2"]').realClick();
      cy.get('a[data-test-subj="cy-keypad-link-2"]').should('have.attr', 'aria-current', 'true');
      cy.checkAxe();
    });
    it('has zero violations on item keypress', function () {
      cy.repeatRealPress('Tab', 3);
      cy.get('button[data-test-subj="cy-keypad-button-3"]').should('have.focus');
      cy.realPress('Space');
      cy.get('button[data-test-subj="cy-keypad-button-3"]').should('have.attr', 'aria-pressed', 'true');
      cy.checkAxe();
      cy.realPress(['Shift', 'Tab']);
      cy.get('button[data-test-subj="cy-keypad-button-2"]').should('have.attr', 'aria-pressed', 'false');
      cy.realPress('Space');
      cy.get('button[data-test-subj="cy-keypad-button-2"]').invoke('attr', 'aria-pressed').should('equal', 'true');
      cy.get('button[data-test-subj="cy-keypad-button-3"]').invoke('attr', 'aria-pressed').should('equal', 'false');
      cy.checkAxe();
    });
  });
});