"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SMALL_SIZE_FORM = exports.MEDIUM_SIZE_FORM = exports.EuiInlineEditForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _form = require("../form");
var _form2 = require("../form/form.styles");
var _button = require("../button");
var _flex = require("../flex");
var _skeleton = require("../skeleton");
var _services = require("../../services");
var _i18n = require("../i18n");
var _accessibility = require("../../services/accessibility");
var _inline_edit_form = require("./inline_edit_form.styles");
var _react2 = require("@emotion/react");
var _excluded = ["className", "children", "sizes", "defaultValue", "value", "onChange", "onCancel", "placeholder", "inputAriaLabel", "startWithEditOpen", "readModeProps", "editModeProps", "isLoading", "isInvalid", "onSave", "isReadOnly"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
// Props shared between the internal form component as well as consumer-facing components
// Internal-only props, passed by the consumer-facing components
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ _regeneratorRuntime = function _regeneratorRuntime() { return exports; }; var exports = {}, Op = Object.prototype, hasOwn = Op.hasOwnProperty, defineProperty = Object.defineProperty || function (obj, key, desc) { obj[key] = desc.value; }, $Symbol = "function" == typeof Symbol ? Symbol : {}, iteratorSymbol = $Symbol.iterator || "@@iterator", asyncIteratorSymbol = $Symbol.asyncIterator || "@@asyncIterator", toStringTagSymbol = $Symbol.toStringTag || "@@toStringTag"; function define(obj, key, value) { return Object.defineProperty(obj, key, { value: value, enumerable: !0, configurable: !0, writable: !0 }), obj[key]; } try { define({}, ""); } catch (err) { define = function define(obj, key, value) { return obj[key] = value; }; } function wrap(innerFn, outerFn, self, tryLocsList) { var protoGenerator = outerFn && outerFn.prototype instanceof Generator ? outerFn : Generator, generator = Object.create(protoGenerator.prototype), context = new Context(tryLocsList || []); return defineProperty(generator, "_invoke", { value: makeInvokeMethod(innerFn, self, context) }), generator; } function tryCatch(fn, obj, arg) { try { return { type: "normal", arg: fn.call(obj, arg) }; } catch (err) { return { type: "throw", arg: err }; } } exports.wrap = wrap; var ContinueSentinel = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var IteratorPrototype = {}; define(IteratorPrototype, iteratorSymbol, function () { return this; }); var getProto = Object.getPrototypeOf, NativeIteratorPrototype = getProto && getProto(getProto(values([]))); NativeIteratorPrototype && NativeIteratorPrototype !== Op && hasOwn.call(NativeIteratorPrototype, iteratorSymbol) && (IteratorPrototype = NativeIteratorPrototype); var Gp = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(IteratorPrototype); function defineIteratorMethods(prototype) { ["next", "throw", "return"].forEach(function (method) { define(prototype, method, function (arg) { return this._invoke(method, arg); }); }); } function AsyncIterator(generator, PromiseImpl) { function invoke(method, arg, resolve, reject) { var record = tryCatch(generator[method], generator, arg); if ("throw" !== record.type) { var result = record.arg, value = result.value; return value && "object" == _typeof(value) && hasOwn.call(value, "__await") ? PromiseImpl.resolve(value.__await).then(function (value) { invoke("next", value, resolve, reject); }, function (err) { invoke("throw", err, resolve, reject); }) : PromiseImpl.resolve(value).then(function (unwrapped) { result.value = unwrapped, resolve(result); }, function (error) { return invoke("throw", error, resolve, reject); }); } reject(record.arg); } var previousPromise; defineProperty(this, "_invoke", { value: function value(method, arg) { function callInvokeWithMethodAndArg() { return new PromiseImpl(function (resolve, reject) { invoke(method, arg, resolve, reject); }); } return previousPromise = previousPromise ? previousPromise.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); } }); } function makeInvokeMethod(innerFn, self, context) { var state = "suspendedStart"; return function (method, arg) { if ("executing" === state) throw new Error("Generator is already running"); if ("completed" === state) { if ("throw" === method) throw arg; return doneResult(); } for (context.method = method, context.arg = arg;;) { var delegate = context.delegate; if (delegate) { var delegateResult = maybeInvokeDelegate(delegate, context); if (delegateResult) { if (delegateResult === ContinueSentinel) continue; return delegateResult; } } if ("next" === context.method) context.sent = context._sent = context.arg;else if ("throw" === context.method) { if ("suspendedStart" === state) throw state = "completed", context.arg; context.dispatchException(context.arg); } else "return" === context.method && context.abrupt("return", context.arg); state = "executing"; var record = tryCatch(innerFn, self, context); if ("normal" === record.type) { if (state = context.done ? "completed" : "suspendedYield", record.arg === ContinueSentinel) continue; return { value: record.arg, done: context.done }; } "throw" === record.type && (state = "completed", context.method = "throw", context.arg = record.arg); } }; } function maybeInvokeDelegate(delegate, context) { var methodName = context.method, method = delegate.iterator[methodName]; if (undefined === method) return context.delegate = null, "throw" === methodName && delegate.iterator.return && (context.method = "return", context.arg = undefined, maybeInvokeDelegate(delegate, context), "throw" === context.method) || "return" !== methodName && (context.method = "throw", context.arg = new TypeError("The iterator does not provide a '" + methodName + "' method")), ContinueSentinel; var record = tryCatch(method, delegate.iterator, context.arg); if ("throw" === record.type) return context.method = "throw", context.arg = record.arg, context.delegate = null, ContinueSentinel; var info = record.arg; return info ? info.done ? (context[delegate.resultName] = info.value, context.next = delegate.nextLoc, "return" !== context.method && (context.method = "next", context.arg = undefined), context.delegate = null, ContinueSentinel) : info : (context.method = "throw", context.arg = new TypeError("iterator result is not an object"), context.delegate = null, ContinueSentinel); } function pushTryEntry(locs) { var entry = { tryLoc: locs[0] }; 1 in locs && (entry.catchLoc = locs[1]), 2 in locs && (entry.finallyLoc = locs[2], entry.afterLoc = locs[3]), this.tryEntries.push(entry); } function resetTryEntry(entry) { var record = entry.completion || {}; record.type = "normal", delete record.arg, entry.completion = record; } function Context(tryLocsList) { this.tryEntries = [{ tryLoc: "root" }], tryLocsList.forEach(pushTryEntry, this), this.reset(!0); } function values(iterable) { if (iterable) { var iteratorMethod = iterable[iteratorSymbol]; if (iteratorMethod) return iteratorMethod.call(iterable); if ("function" == typeof iterable.next) return iterable; if (!isNaN(iterable.length)) { var i = -1, next = function next() { for (; ++i < iterable.length;) if (hasOwn.call(iterable, i)) return next.value = iterable[i], next.done = !1, next; return next.value = undefined, next.done = !0, next; }; return next.next = next; } } return { next: doneResult }; } function doneResult() { return { value: undefined, done: !0 }; } return GeneratorFunction.prototype = GeneratorFunctionPrototype, defineProperty(Gp, "constructor", { value: GeneratorFunctionPrototype, configurable: !0 }), defineProperty(GeneratorFunctionPrototype, "constructor", { value: GeneratorFunction, configurable: !0 }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, toStringTagSymbol, "GeneratorFunction"), exports.isGeneratorFunction = function (genFun) { var ctor = "function" == typeof genFun && genFun.constructor; return !!ctor && (ctor === GeneratorFunction || "GeneratorFunction" === (ctor.displayName || ctor.name)); }, exports.mark = function (genFun) { return Object.setPrototypeOf ? Object.setPrototypeOf(genFun, GeneratorFunctionPrototype) : (genFun.__proto__ = GeneratorFunctionPrototype, define(genFun, toStringTagSymbol, "GeneratorFunction")), genFun.prototype = Object.create(Gp), genFun; }, exports.awrap = function (arg) { return { __await: arg }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, asyncIteratorSymbol, function () { return this; }), exports.AsyncIterator = AsyncIterator, exports.async = function (innerFn, outerFn, self, tryLocsList, PromiseImpl) { void 0 === PromiseImpl && (PromiseImpl = Promise); var iter = new AsyncIterator(wrap(innerFn, outerFn, self, tryLocsList), PromiseImpl); return exports.isGeneratorFunction(outerFn) ? iter : iter.next().then(function (result) { return result.done ? result.value : iter.next(); }); }, defineIteratorMethods(Gp), define(Gp, toStringTagSymbol, "Generator"), define(Gp, iteratorSymbol, function () { return this; }), define(Gp, "toString", function () { return "[object Generator]"; }), exports.keys = function (val) { var object = Object(val), keys = []; for (var key in object) keys.push(key); return keys.reverse(), function next() { for (; keys.length;) { var key = keys.pop(); if (key in object) return next.value = key, next.done = !1, next; } return next.done = !0, next; }; }, exports.values = values, Context.prototype = { constructor: Context, reset: function reset(skipTempReset) { if (this.prev = 0, this.next = 0, this.sent = this._sent = undefined, this.done = !1, this.delegate = null, this.method = "next", this.arg = undefined, this.tryEntries.forEach(resetTryEntry), !skipTempReset) for (var name in this) "t" === name.charAt(0) && hasOwn.call(this, name) && !isNaN(+name.slice(1)) && (this[name] = undefined); }, stop: function stop() { this.done = !0; var rootRecord = this.tryEntries[0].completion; if ("throw" === rootRecord.type) throw rootRecord.arg; return this.rval; }, dispatchException: function dispatchException(exception) { if (this.done) throw exception; var context = this; function handle(loc, caught) { return record.type = "throw", record.arg = exception, context.next = loc, caught && (context.method = "next", context.arg = undefined), !!caught; } for (var i = this.tryEntries.length - 1; i >= 0; --i) { var entry = this.tryEntries[i], record = entry.completion; if ("root" === entry.tryLoc) return handle("end"); if (entry.tryLoc <= this.prev) { var hasCatch = hasOwn.call(entry, "catchLoc"), hasFinally = hasOwn.call(entry, "finallyLoc"); if (hasCatch && hasFinally) { if (this.prev < entry.catchLoc) return handle(entry.catchLoc, !0); if (this.prev < entry.finallyLoc) return handle(entry.finallyLoc); } else if (hasCatch) { if (this.prev < entry.catchLoc) return handle(entry.catchLoc, !0); } else { if (!hasFinally) throw new Error("try statement without catch or finally"); if (this.prev < entry.finallyLoc) return handle(entry.finallyLoc); } } } }, abrupt: function abrupt(type, arg) { for (var i = this.tryEntries.length - 1; i >= 0; --i) { var entry = this.tryEntries[i]; if (entry.tryLoc <= this.prev && hasOwn.call(entry, "finallyLoc") && this.prev < entry.finallyLoc) { var finallyEntry = entry; break; } } finallyEntry && ("break" === type || "continue" === type) && finallyEntry.tryLoc <= arg && arg <= finallyEntry.finallyLoc && (finallyEntry = null); var record = finallyEntry ? finallyEntry.completion : {}; return record.type = type, record.arg = arg, finallyEntry ? (this.method = "next", this.next = finallyEntry.finallyLoc, ContinueSentinel) : this.complete(record); }, complete: function complete(record, afterLoc) { if ("throw" === record.type) throw record.arg; return "break" === record.type || "continue" === record.type ? this.next = record.arg : "return" === record.type ? (this.rval = this.arg = record.arg, this.method = "return", this.next = "end") : "normal" === record.type && afterLoc && (this.next = afterLoc), ContinueSentinel; }, finish: function finish(finallyLoc) { for (var i = this.tryEntries.length - 1; i >= 0; --i) { var entry = this.tryEntries[i]; if (entry.finallyLoc === finallyLoc) return this.complete(entry.completion, entry.afterLoc), resetTryEntry(entry), ContinueSentinel; } }, catch: function _catch(tryLoc) { for (var i = this.tryEntries.length - 1; i >= 0; --i) { var entry = this.tryEntries[i]; if (entry.tryLoc === tryLoc) { var record = entry.completion; if ("throw" === record.type) { var thrown = record.arg; resetTryEntry(entry); } return thrown; } } throw new Error("illegal catch attempt"); }, delegateYield: function delegateYield(iterable, resultName, nextLoc) { return this.delegate = { iterator: values(iterable), resultName: resultName, nextLoc: nextLoc }, "next" === this.method && (this.arg = undefined), ContinueSentinel; } }, exports; }
function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }
function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(arr, i) { var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"]; if (null != _i) { var _s, _e, _x, _r, _arr = [], _n = !0, _d = !1; try { if (_x = (_i = _i.call(arr)).next, 0 === i) { if (Object(_i) !== _i) return; _n = !1; } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0); } catch (err) { _d = !0, _e = err; } finally { try { if (!_n && null != _i.return && (_r = _i.return(), Object(_r) !== _r)) return; } finally { if (_d) throw _e; } } return _arr; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
var SMALL_SIZE_FORM = {
  iconSize: 's',
  compressed: true,
  buttonSize: 's'
};
exports.SMALL_SIZE_FORM = SMALL_SIZE_FORM;
var MEDIUM_SIZE_FORM = {
  iconSize: 'm',
  compressed: false,
  buttonSize: 'm'
};
exports.MEDIUM_SIZE_FORM = MEDIUM_SIZE_FORM;
var EuiInlineEditForm = function EuiInlineEditForm(_ref) {
  var _editModeProps$inputP, _editModeProps$formRo, _editModeProps$inputP6;
  var className = _ref.className,
    children = _ref.children,
    sizes = _ref.sizes,
    _ref$defaultValue = _ref.defaultValue,
    defaultValue = _ref$defaultValue === void 0 ? '' : _ref$defaultValue,
    _ref$value = _ref.value,
    controlledValue = _ref$value === void 0 ? '' : _ref$value,
    _onChange = _ref.onChange,
    onCancel = _ref.onCancel,
    _ref$placeholder = _ref.placeholder,
    placeholder = _ref$placeholder === void 0 ? '' : _ref$placeholder,
    inputAriaLabel = _ref.inputAriaLabel,
    startWithEditOpen = _ref.startWithEditOpen,
    readModeProps = _ref.readModeProps,
    editModeProps = _ref.editModeProps,
    _ref$isLoading = _ref.isLoading,
    isLoading = _ref$isLoading === void 0 ? false : _ref$isLoading,
    isInvalid = _ref.isInvalid,
    onSave = _ref.onSave,
    isReadOnly = _ref.isReadOnly,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = (0, _classnames.default)('euiInlineEdit', className);
  var euiTheme = (0, _services.useEuiTheme)();
  var _euiFormVariables = (0, _form2.euiFormVariables)(euiTheme),
    controlHeight = _euiFormVariables.controlHeight,
    controlCompressedHeight = _euiFormVariables.controlCompressedHeight;
  var loadingSkeletonSize = sizes.compressed ? controlCompressedHeight : controlHeight;
  var defaultSaveButtonAriaLabel = (0, _i18n.useEuiI18n)('euiInlineEditForm.saveButtonAriaLabel', 'Save edit');
  var defaultCancelButtonAriaLabel = (0, _i18n.useEuiI18n)('euiInlineEditForm.cancelButtonAriaLabel', 'Cancel edit');
  var readModeDescribedById = (0, _accessibility.useGeneratedHtmlId)({
    prefix: 'inlineEdit'
  });
  var editModeDescribedById = (0, _accessibility.useGeneratedHtmlId)({
    prefix: 'inlineEdit'
  });
  var readModeFocusRef = (0, _react.useRef)(null);
  var editModeFocusRef = (0, _react.useRef)(null);
  var setReadModeRefs = (0, _services.useCombinedRefs)([readModeFocusRef, readModeProps === null || readModeProps === void 0 ? void 0 : readModeProps.buttonRef]);
  var setEditModeRefs = (0, _services.useCombinedRefs)([editModeFocusRef, editModeProps === null || editModeProps === void 0 ? void 0 : (_editModeProps$inputP = editModeProps.inputProps) === null || _editModeProps$inputP === void 0 ? void 0 : _editModeProps$inputP.inputRef]);
  var _useState = (0, _react.useState)(false || startWithEditOpen),
    _useState2 = _slicedToArray(_useState, 2),
    isEditing = _useState2[0],
    setIsEditing = _useState2[1];
  var _useState3 = (0, _react.useState)(defaultValue),
    _useState4 = _slicedToArray(_useState3, 2),
    editModeValue = _useState4[0],
    setEditModeValue = _useState4[1];

  // readModeValue accepts controlledValue here to provide a reliable backup for the onCancel callback
  var _useState5 = (0, _react.useState)(controlledValue || defaultValue),
    _useState6 = _slicedToArray(_useState5, 2),
    readModeValue = _useState6[0],
    setReadModeValue = _useState6[1];
  var value = (0, _react.useMemo)(function () {
    if (controlledValue) {
      return controlledValue;
    } else {
      return isEditing ? editModeValue : readModeValue || placeholder;
    }
  }, [controlledValue, editModeValue, readModeValue, isEditing, placeholder]);
  var readModeStyles = (0, _inline_edit_form.euiInlineEditReadModeStyles)(euiTheme);
  var readModeCssStyles = [readModeStyles.euiInlineEditReadMode, isReadOnly && readModeStyles.isReadOnly, placeholder && !readModeValue && readModeStyles.hasPlaceholder];
  var activateEditMode = function activateEditMode() {
    setIsEditing(true);
    // Waits a tick for state to settle and the focus target to render
    requestAnimationFrame(function () {
      var _editModeFocusRef$cur;
      return (_editModeFocusRef$cur = editModeFocusRef.current) === null || _editModeFocusRef$cur === void 0 ? void 0 : _editModeFocusRef$cur.focus();
    });
  };
  var cancelInlineEdit = function cancelInlineEdit() {
    setEditModeValue(readModeValue);
    onCancel === null || onCancel === void 0 ? void 0 : onCancel(readModeValue);
    setIsEditing(false);
    requestAnimationFrame(function () {
      var _readModeFocusRef$cur;
      return (_readModeFocusRef$cur = readModeFocusRef.current) === null || _readModeFocusRef$cur === void 0 ? void 0 : _readModeFocusRef$cur.focus();
    });
  };
  var saveInlineEditValue = /*#__PURE__*/function () {
    var _ref2 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee() {
      var onSaveReturn, awaitedReturn;
      return _regeneratorRuntime().wrap(function _callee$(_context) {
        while (1) switch (_context.prev = _context.next) {
          case 0:
            if (!onSave) {
              _context.next = 12;
              break;
            }
            onSaveReturn = onSave(value);
            if (!(onSaveReturn instanceof Promise)) {
              _context.next = 8;
              break;
            }
            _context.next = 5;
            return onSaveReturn;
          case 5:
            _context.t0 = _context.sent;
            _context.next = 9;
            break;
          case 8:
            _context.t0 = onSaveReturn;
          case 9:
            awaitedReturn = _context.t0;
            if (!(awaitedReturn === false)) {
              _context.next = 12;
              break;
            }
            return _context.abrupt("return");
          case 12:
            setReadModeValue(editModeValue);
            setIsEditing(false);
            requestAnimationFrame(function () {
              var _readModeFocusRef$cur2;
              return (_readModeFocusRef$cur2 = readModeFocusRef.current) === null || _readModeFocusRef$cur2 === void 0 ? void 0 : _readModeFocusRef$cur2.focus();
            });
          case 15:
          case "end":
            return _context.stop();
        }
      }, _callee);
    }));
    return function saveInlineEditValue() {
      return _ref2.apply(this, arguments);
    };
  }();
  var editModeInputOnKeyDown = function editModeInputOnKeyDown(event) {
    switch (event.key) {
      case _services.keys.ENTER:
        event.preventDefault(); // Enter keypresses will not proceed otherwise on webkit browsers & screen readers
        saveInlineEditValue();
        break;
      case _services.keys.ESCAPE:
        cancelInlineEdit();
        break;
    }
  };

  // If the state of isReadOnly changes while in edit mode, switch back to read mode
  (0, _react.useEffect)(function () {
    if (isReadOnly) {
      setIsEditing(false);
    }
  }, [isReadOnly]);
  var editModeForm = (0, _react2.jsx)(_flex.EuiFlexGroup, {
    gutterSize: "s",
    responsive: false
  }, (0, _react2.jsx)(_flex.EuiFlexItem, null, (0, _react2.jsx)(_form.EuiFormRow, _extends({
    fullWidth: true,
    isInvalid: isInvalid,
    error: isInvalid && (editModeProps === null || editModeProps === void 0 ? void 0 : (_editModeProps$formRo = editModeProps.formRowProps) === null || _editModeProps$formRo === void 0 ? void 0 : _editModeProps$formRo.error)
  }, editModeProps === null || editModeProps === void 0 ? void 0 : editModeProps.formRowProps), (0, _react2.jsx)(_form.EuiFieldText, _extends({
    fullWidth: true,
    value: value,
    "aria-label": inputAriaLabel,
    compressed: sizes.compressed,
    isInvalid: isInvalid,
    isLoading: isLoading,
    "data-test-subj": "euiInlineEditModeInput",
    placeholder: placeholder || undefined // Opt not to render the prop entirely if an empty string is passed
  }, editModeProps === null || editModeProps === void 0 ? void 0 : editModeProps.inputProps, {
    inputRef: setEditModeRefs,
    onChange: function onChange(e) {
      var _editModeProps$inputP2, _editModeProps$inputP3;
      setEditModeValue(e.target.value);
      _onChange === null || _onChange === void 0 ? void 0 : _onChange(e);
      editModeProps === null || editModeProps === void 0 ? void 0 : (_editModeProps$inputP2 = editModeProps.inputProps) === null || _editModeProps$inputP2 === void 0 ? void 0 : (_editModeProps$inputP3 = _editModeProps$inputP2.onChange) === null || _editModeProps$inputP3 === void 0 ? void 0 : _editModeProps$inputP3.call(_editModeProps$inputP2, e);
    },
    onKeyDown: function onKeyDown(e) {
      var _editModeProps$inputP4, _editModeProps$inputP5;
      editModeInputOnKeyDown(e);
      editModeProps === null || editModeProps === void 0 ? void 0 : (_editModeProps$inputP4 = editModeProps.inputProps) === null || _editModeProps$inputP4 === void 0 ? void 0 : (_editModeProps$inputP5 = _editModeProps$inputP4.onKeyDown) === null || _editModeProps$inputP5 === void 0 ? void 0 : _editModeProps$inputP5.call(_editModeProps$inputP4, e);
    },
    "aria-describedby": (0, _classnames.default)(editModeDescribedById, editModeProps === null || editModeProps === void 0 ? void 0 : (_editModeProps$inputP6 = editModeProps.inputProps) === null || _editModeProps$inputP6 === void 0 ? void 0 : _editModeProps$inputP6['aria-describedby'])
  }))), (0, _react2.jsx)("span", {
    id: editModeDescribedById,
    hidden: true
  }, (0, _react2.jsx)(_i18n.EuiI18n, {
    token: "euiInlineEditForm.inputKeyboardInstructions",
    default: "Press Enter to save your edited text. Press Escape to cancel your edit."
  }))), (0, _react2.jsx)(_flex.EuiFlexItem, {
    grow: false
  }, (0, _react2.jsx)(_skeleton.EuiSkeletonLoading, {
    isLoading: isLoading,
    announceLoadingStatus: true,
    announceLoadedStatus: false,
    loadingContent: (0, _react2.jsx)(_flex.EuiFlexGroup, {
      gutterSize: "s"
    }, (0, _react2.jsx)(_skeleton.EuiSkeletonRectangle, {
      height: loadingSkeletonSize,
      width: loadingSkeletonSize,
      borderRadius: "m"
    }), (0, _react2.jsx)(_skeleton.EuiSkeletonRectangle, {
      height: loadingSkeletonSize,
      width: loadingSkeletonSize,
      borderRadius: "m"
    })),
    loadedContent: (0, _react2.jsx)(_flex.EuiFlexGroup, {
      gutterSize: "s"
    }, (0, _react2.jsx)(_button.EuiButtonIcon, _extends({
      iconType: "check",
      "aria-label": defaultSaveButtonAriaLabel,
      color: "success",
      display: "base",
      size: sizes.buttonSize,
      iconSize: sizes.iconSize,
      "data-test-subj": "euiInlineEditModeSaveButton"
    }, editModeProps === null || editModeProps === void 0 ? void 0 : editModeProps.saveButtonProps, {
      onClick: function onClick(e) {
        var _editModeProps$saveBu, _editModeProps$saveBu2;
        saveInlineEditValue();
        editModeProps === null || editModeProps === void 0 ? void 0 : (_editModeProps$saveBu = editModeProps.saveButtonProps) === null || _editModeProps$saveBu === void 0 ? void 0 : (_editModeProps$saveBu2 = _editModeProps$saveBu.onClick) === null || _editModeProps$saveBu2 === void 0 ? void 0 : _editModeProps$saveBu2.call(_editModeProps$saveBu, e);
      }
    })), (0, _react2.jsx)(_button.EuiButtonIcon, _extends({
      iconType: "cross",
      "aria-label": defaultCancelButtonAriaLabel,
      color: "danger",
      display: "base",
      size: sizes.buttonSize,
      iconSize: sizes.iconSize,
      "data-test-subj": "euiInlineEditModeCancelButton"
    }, editModeProps === null || editModeProps === void 0 ? void 0 : editModeProps.cancelButtonProps, {
      onClick: function onClick(e) {
        var _editModeProps$cancel, _editModeProps$cancel2;
        cancelInlineEdit();
        editModeProps === null || editModeProps === void 0 ? void 0 : (_editModeProps$cancel = editModeProps.cancelButtonProps) === null || _editModeProps$cancel === void 0 ? void 0 : (_editModeProps$cancel2 = _editModeProps$cancel.onClick) === null || _editModeProps$cancel2 === void 0 ? void 0 : _editModeProps$cancel2.call(_editModeProps$cancel, e);
      }
    })))
  })));
  var readModeElement = (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)(_button.EuiButtonEmpty, _extends({
    color: "text",
    iconType: isReadOnly ? undefined : 'pencil',
    iconSide: "right",
    flush: "both",
    iconSize: sizes.iconSize,
    size: sizes.buttonSize,
    "data-test-subj": "euiInlineReadModeButton",
    disabled: isReadOnly,
    css: readModeCssStyles,
    title: value
  }, readModeProps, {
    buttonRef: setReadModeRefs,
    "aria-describedby": (0, _classnames.default)(readModeDescribedById, readModeProps === null || readModeProps === void 0 ? void 0 : readModeProps['aria-describedby']),
    onClick: function onClick(e) {
      var _readModeProps$onClic;
      activateEditMode();
      readModeProps === null || readModeProps === void 0 ? void 0 : (_readModeProps$onClic = readModeProps.onClick) === null || _readModeProps$onClic === void 0 ? void 0 : _readModeProps$onClic.call(readModeProps, e);
    }
  }), children(value)), (0, _react2.jsx)("span", {
    id: readModeDescribedById,
    hidden: true
  }, !isReadOnly && (0, _react2.jsx)(_i18n.EuiI18n, {
    token: "euiInlineEditForm.activateEditModeDescription",
    default: "Click to edit this text inline."
  })));
  return (0, _react2.jsx)("div", _extends({
    className: classes
  }, rest), isEditing ? editModeForm : readModeElement);
};
exports.EuiInlineEditForm = EuiInlineEditForm;
EuiInlineEditForm.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  placeholder: _propTypes.default.string,
  /**
       * Callback that fires when a user clicks the save button.
       * Passes the current edited text value as an argument.
       *
       * To validate the value of the edited text, pass back a boolean flag.
       * If `false`, EuiInlineEdit will remain in edit mode, where loading or invalid states can be set.
       * If `true`, EuiInlineEdit will return to read mode.
       */
  onSave: _propTypes.default.func,
  /**
       * Form label that appears above the form control.
       * This is required for accessibility because there is no visual label on the input.
       */
  inputAriaLabel: _propTypes.default.string.isRequired,
  /**
       * Starts the component in edit mode
       */
  startWithEditOpen: _propTypes.default.bool,
  /**
       * Props that will be applied directly to the `EuiEmptyButton` displayed in read mode
       */
  readModeProps: _propTypes.default.any,
  /**
       * Multiple props objects that can be applied directly to various child components displayed in edit mode.
       * - `formRowProps` will be passed to `EuiFormRow`
       * - `inputProps` will be passed to `EuiFieldText`
       * - `saveButtonProps` & `cancelButtonProps` will be passed to their respective `EuiIconButton`s
       */
  editModeProps: _propTypes.default.shape({
    formRowProps: _propTypes.default.any,
    inputProps: _propTypes.default.any,
    saveButtonProps: _propTypes.default.any,
    cancelButtonProps: _propTypes.default.any
  }),
  /**
       * Loading state - only displayed in edit mode
       */
  isLoading: _propTypes.default.bool,
  /**
       * Invalid state - only displayed edit mode
       */
  isInvalid: _propTypes.default.bool,
  /**
       * Locks inline edit in read mode and displays the text value
       */
  isReadOnly: _propTypes.default.bool,
  /**
         * Initial inline edit text value
         */
  defaultValue: _propTypes.default.string,
  /**
         * To use inline edit as a controlled component, continuously pass the value via this prop
         */
  value: _propTypes.default.string,
  /**
         * Callback required to receive and update `value` based on user input
         */
  onChange: _propTypes.default.func,
  /**
         * Callback required to reset `value` to the previous read mode text value.
         */
  onCancel: _propTypes.default.func,
  /**
     * Form sizes
     */
  sizes: _propTypes.default.shape({
    compressed: _propTypes.default.bool.isRequired,
    buttonSize: _propTypes.default.any.isRequired,
    iconSize: _propTypes.default.any.isRequired
  }).isRequired,
  /**
     * Render prop that returns the read mode value as an arg
     */
  children: _propTypes.default.func.isRequired
};