"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SIZES = exports.MARGINS = exports.EuiHorizontalRule = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _horizontal_rule = require("./horizontal_rule.styles");
var _react2 = require("@emotion/react");
var _excluded = ["className", "size", "margin"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
var SIZES = ['full', 'half', 'quarter'];
exports.SIZES = SIZES;
var MARGINS = ['none', 'xs', 's', 'm', 'l', 'xl', 'xxl'];
exports.MARGINS = MARGINS;
var EuiHorizontalRule = function EuiHorizontalRule(_ref) {
  var className = _ref.className,
    _ref$size = _ref.size,
    size = _ref$size === void 0 ? 'full' : _ref$size,
    _ref$margin = _ref.margin,
    margin = _ref$margin === void 0 ? 'l' : _ref$margin,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = (0, _classnames.default)('euiHorizontalRule', className);
  var styles = (0, _services.useEuiMemoizedStyles)(_horizontal_rule.euiHorizontalRuleStyles);
  var cssStyles = [styles.euiHorizontalRule, styles[size], styles[margin]];
  return (0, _react2.jsx)("hr", _extends({
    css: cssStyles,
    className: classes
  }, rest));
};
exports.EuiHorizontalRule = EuiHorizontalRule;
EuiHorizontalRule.propTypes = {
  /**
     * Defines the width of the HR.
     */
  size: _propTypes.default.any,
  margin: _propTypes.default.any,
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any
};