"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiHighlight = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _mark = require("../mark");
var _highlight_all = require("./_highlight_all");
var _highlight_first = require("./_highlight_first");
var _react2 = require("@emotion/react");
var _excluded = ["children", "className", "search", "strict", "highlightAll", "hasScreenReaderHelpText"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
var EuiHighlight = function EuiHighlight(_ref) {
  var children = _ref.children,
    className = _ref.className,
    search = _ref.search,
    _ref$strict = _ref.strict,
    strict = _ref$strict === void 0 ? false : _ref$strict,
    _ref$highlightAll = _ref.highlightAll,
    highlightAll = _ref$highlightAll === void 0 ? false : _ref$highlightAll,
    _ref$hasScreenReaderH = _ref.hasScreenReaderHelpText,
    hasScreenReaderHelpText = _ref$hasScreenReaderH === void 0 ? true : _ref$hasScreenReaderH,
    rest = _objectWithoutProperties(_ref, _excluded);
  var hasSearch = search && search.length > 0;
  var HighlightComponent = (0, _react.useMemo)(function () {
    var Component = function Component(_ref2) {
      var children = _ref2.children;
      return (0, _react2.jsx)(_mark.EuiMark, {
        hasScreenReaderHelpText: hasScreenReaderHelpText
      }, children);
    };
    Component.propTypes = {
      children: _propTypes.default.string.isRequired
    };
    Component.displayName = '_HighlightComponent';
    return Component;
  }, [hasScreenReaderHelpText]);
  return (0, _react2.jsx)("span", _extends({
    className: className
  }, rest), children && hasSearch ? highlightAll ? (0, _react2.jsx)(_highlight_all.HighlightAll, {
    searchValue: search,
    searchSubject: children,
    isStrict: strict,
    highlightComponent: HighlightComponent
  }) : (0, _react2.jsx)(_highlight_first.HighlightFirst, {
    searchValue: search,
    searchSubject: children,
    isStrict: strict,
    highlightComponent: HighlightComponent
  }) : children);
};
exports.EuiHighlight = EuiHighlight;
EuiHighlight.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  /**
       * string to highlight as this component's content
       */
  children: _propTypes.default.string.isRequired,
  /**
       * What to search for.
       *
       * Allows passing an array of strings (searching by multiple separate
       * words or phrases) **only** if `highlightAll` is also set to `true`.
       */
  search: _propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.arrayOf(_propTypes.default.string.isRequired).isRequired]).isRequired,
  /**
       * Should the search be strict or not
       */
  strict: _propTypes.default.bool,
  /**
       * Should highlight all matches
       */
  highlightAll: _propTypes.default.bool
};