"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HighlightAll = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _escapeRegExp = _interopRequireDefault(require("lodash/escapeRegExp"));
var _react2 = require("@emotion/react");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }
function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; } /*
                                                                                                                                                                                     * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                     * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                     * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                     * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                     * Side Public License, v 1.
                                                                                                                                                                                     */
/**
 * Internal subcomponent with logic for highlighting all occurrences
 * of a search value within a subject
 *
 * Uses regex rather than indexOf/while loops for easier dev maintainability
 */
var HighlightAll = function HighlightAll(_ref) {
  var searchSubject = _ref.searchSubject,
    _searchValue = _ref.searchValue,
    isStrict = _ref.isStrict,
    _ref$highlightCompone = _ref.highlightComponent,
    HighlightComponent = _ref$highlightCompone === void 0 ? 'mark' : _ref$highlightCompone;
  var searchValue = (0, _react.useMemo)(function () {
    return Array.isArray(_searchValue) ? _searchValue.map(_escapeRegExp.default).join('|') : (0, _escapeRegExp.default)(_searchValue);
  }, [_searchValue]);
  var chunks = (0, _react.useMemo)(function () {
    var regex = new RegExp(searchValue, isStrict ? 'g' : 'gi');
    var matches = _toConsumableArray(searchSubject.matchAll(regex)).map(function (match) {
      return {
        start: match.index || 0,
        end: (match.index || 0) + match[0].length
      };
    });
    return fillInChunks(matches, searchSubject.length);
  }, [searchValue, searchSubject, isStrict]);
  return (0, _react2.jsx)(_react.default.Fragment, null, chunks.map(function (chunk) {
    var end = chunk.end,
      highlight = chunk.highlight,
      start = chunk.start;
    var value = searchSubject.substring(start, end);
    return highlight ? (0, _react2.jsx)(HighlightComponent, {
      key: start
    }, value) : value;
  }));
};

/**
 * Chunk utility
 */
exports.HighlightAll = HighlightAll;
HighlightAll.propTypes = {
  searchValue: _propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.arrayOf(_propTypes.default.string.isRequired).isRequired]).isRequired,
  searchSubject: _propTypes.default.string.isRequired,
  isStrict: _propTypes.default.bool.isRequired,
  highlightComponent: _propTypes.default.any
};
var fillInChunks = function fillInChunks(chunksToHighlight, totalLength) {
  var allChunks = [];
  var append = function append(start, end, highlight) {
    if (end - start > 0) {
      allChunks.push({
        start: start,
        end: end,
        highlight: highlight
      });
    }
  };
  if (chunksToHighlight.length === 0) {
    append(0, totalLength, false);
  } else {
    var lastIndex = 0;
    chunksToHighlight.forEach(function (chunk) {
      append(lastIndex, chunk.start, false);
      append(chunk.start, chunk.end, true);
      lastIndex = chunk.end;
    });
    append(lastIndex, totalLength, false);
  }
  return allChunks;
};