"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
var _react = _interopRequireWildcard(require("react"));
var _dual_range = require("./dual_range");
var _range = require("./range");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(arr, i) { var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"]; if (null != _i) { var _s, _e, _x, _r, _arr = [], _n = !0, _d = !1; try { if (_x = (_i = _i.call(arr)).next, 0 === i) { if (Object(_i) !== _i) return; _n = !1; } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0); } catch (err) { _d = !0, _e = err; } finally { try { if (!_n && null != _i.return && (_r = _i.return(), Object(_r) !== _r)) return; } finally { if (_d) throw _e; } } return _arr; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; } /*
                                                                       * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                       * or more contributor license agreements. Licensed under the Elastic License
                                                                       * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                       * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                       * Side Public License, v 1.
                                                                       */ /// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../../cypress/support" />
describe('Single EuiRange', function () {
  var SingleRange = function SingleRange() {
    var _useState = (0, _react.useState)('100'),
      _useState2 = _slicedToArray(_useState, 2),
      value = _useState2[0],
      setValue = _useState2[1];
    var onChange = function onChange(e) {
      setValue(e.currentTarget.value);
    };
    return (0, _react2.jsx)(_range.EuiRange, {
      id: "cy-range-single",
      min: 100,
      max: 200,
      value: value,
      onChange: onChange,
      showLabels: true,
      showRange: true,
      showValue: true,
      valuePrepend: "100 - ",
      "aria-label": "An example of EuiRange with valuePrepend prop"
    });
  };
  beforeEach(function () {
    cy.viewport(1024, 768); // medium breakpoint
    cy.realMount((0, _react2.jsx)(SingleRange, null));
    cy.get('div.euiRangeWrapper').should('exist');
  });
  describe('Automated accessibility check', function () {
    it('has zero violations on first render', function () {
      cy.checkAxe();
    });
  });
  describe('Keyboard accessibility check', function () {
    it('has zero violations when the range slider is increased', function () {
      cy.get('input#cy-range-single').focus();
      cy.repeatRealPress('ArrowRight', 10);
      cy.get('output.euiRangeTooltip__value').contains('100 - 110');
      cy.checkAxe();
    });
    it('has zero violations when the range slider is decreased', function () {
      cy.get('input#cy-range-single').focus();
      cy.repeatRealPress('ArrowLeft', 10);
      cy.get('output.euiRangeTooltip__value').contains('100 - 100');
      cy.checkAxe();
    });
  });
});
describe('Dual EuiRange', function () {
  var DualRange = function DualRange() {
    var _useState3 = (0, _react.useState)(['100', '150']),
      _useState4 = _slicedToArray(_useState3, 2),
      dualValue = _useState4[0],
      setDualValue = _useState4[1];
    var onDualChange = function onDualChange(value) {
      setDualValue(value);
    };
    return (0, _react2.jsx)(_dual_range.EuiDualRange, {
      id: "cy-range-dual",
      min: 0,
      max: 300,
      step: 10,
      value: dualValue,
      onChange: onDualChange,
      showLabels: true,
      "aria-label": "An example of EuiDualRange"
    });
  };
  beforeEach(function () {
    cy.viewport(1024, 768); // medium breakpoint
    cy.realMount((0, _react2.jsx)(DualRange, null));
    cy.get('div.euiRangeWrapper').should('exist');
  });
  describe('Automated accessibility check', function () {
    it('has zero violations on first render', function () {
      cy.checkAxe();
    });
  });
  describe('Keyboard accessibility check', function () {
    it('has zero violations when the range sliders are adjusted', function () {
      cy.get('div[role="slider"]').first().focus();
      cy.repeatRealPress('ArrowLeft', 3);
      cy.get('div[role="slider"]').first().invoke('attr', 'aria-valuenow').should('eq', '70');
      cy.realPress('Tab');
      cy.get('div[role="slider"]').last().should('have.focus');
      cy.repeatRealPress('ArrowRight', 3);
      cy.get('div[role="slider"]').last().invoke('attr', 'aria-valuenow').should('eq', '180');
      cy.checkAxe();
    });
  });
});
describe('Highlight Area EuiRange', function () {
  var DraggableRange = function DraggableRange() {
    var _useState5 = (0, _react.useState)(['40', '60']),
      _useState6 = _slicedToArray(_useState5, 2),
      dualValue = _useState6[0],
      setDualValue = _useState6[1];
    return (0, _react2.jsx)(_dual_range.EuiDualRange, {
      id: "cy-range-draggable",
      min: 0,
      max: 100,
      step: 1,
      value: dualValue,
      onChange: setDualValue,
      showLabels: true,
      "aria-label": "An example of EuiDualRange with isDraggable='true'",
      isDraggable: true
    });
  };
  beforeEach(function () {
    cy.viewport(1024, 768); // medium breakpoint
    cy.realMount((0, _react2.jsx)(DraggableRange, null));
    cy.get('div.euiRangeWrapper').should('exist');
  });
  describe('Automated accessibility check', function () {
    it('has zero violations on first render', function () {
      cy.checkAxe();
    });
  });
  describe('Keyboard accessibility check', function () {
    it('has zero violations when the highlight area is adjusted using arrow keys', function () {
      cy.get('div[role="slider"]').first().focus();
      cy.repeatRealPress('ArrowLeft', 3);
      cy.get('div[role="slider"]').first().invoke('attr', 'aria-valuetext').should('eq', '37, 57');
      cy.checkAxe();
    });
  });
  describe('Drag and drop accessibility check', function () {
    it('has zero violations when the higlight area is dragged using a mouse', function () {
      cy.get('.euiRangeDraggable__inner').realMouseDown({
        position: 'center'
      }).realMouseMove(100, 0, {}).realMouseUp();
      cy.checkAxe();
    });
  });
  describe('EuiRange in a dropdown', function () {
    var InputWithRange = function InputWithRange() {
      var _useState7 = (0, _react.useState)('20'),
        _useState8 = _slicedToArray(_useState7, 2),
        value = _useState8[0],
        setValue = _useState8[1];
      return (0, _react2.jsx)(_range.EuiRange, {
        id: "cy-range-in-dropdown",
        min: 0,
        max: 100,
        value: value,
        onChange: function onChange(e) {
          return setValue(e.currentTarget.value);
        },
        showInput: "inputWithPopover",
        showLabels: true,
        "aria-label": "An example of EuiRange with showInput prop"
      });
    };
    beforeEach(function () {
      cy.viewport(1024, 768); // medium breakpoint
      cy.realMount((0, _react2.jsx)(InputWithRange, null));
      cy.get('input#cy-range-in-dropdown').should('exist');
    });
    describe('Automated accessibility check', function () {
      it('has zero violations on first render', function () {
        cy.checkAxe();
      });
    });
    describe('Keyboard accessibility check', function () {
      it('updates the range value using arrow keys with input[type="number"]', function () {
        cy.get('input#cy-range-in-dropdown').focus();
        cy.repeatRealPress('ArrowUp', 10);
        cy.get('input[type="range"]').first().invoke('attr', 'value').should('eq', '30');
        cy.checkAxe();
      });
    });
  });
});