"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiFlyoutBody = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _flyout_body = require("./flyout_body.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "className", "banner", "scrollableTabIndex"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
var EuiFlyoutBody = function EuiFlyoutBody(_ref) {
  var children = _ref.children,
    className = _ref.className,
    banner = _ref.banner,
    _ref$scrollableTabInd = _ref.scrollableTabIndex,
    scrollableTabIndex = _ref$scrollableTabInd === void 0 ? 0 : _ref$scrollableTabInd,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = (0, _classnames.default)('euiFlyoutBody', className);
  var styles = (0, _services.useEuiMemoizedStyles)(_flyout_body.euiFlyoutBodyStyles);
  var overflowCssStyles = [styles.overflow.euiFlyoutBody__overflow, banner ? styles.overflow.hasBanner : styles.overflow.noBanner];
  return (0, _react2.jsx)("div", _extends({
    className: classes,
    css: styles.euiFlyoutBody
  }, rest), (0, _react2.jsx)("div", {
    tabIndex: scrollableTabIndex,
    className: "euiFlyoutBody__overflow",
    css: overflowCssStyles
  }, banner && (0, _react2.jsx)("div", {
    className: "euiFlyoutBody__banner",
    css: styles.euiFlyoutBody__banner
  }, banner), (0, _react2.jsx)("div", {
    className: "euiFlyoutBody__overflowContent"
  }, children)));
};
exports.EuiFlyoutBody = EuiFlyoutBody;
EuiFlyoutBody.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  /**
         * Use to display a banner at the top of the body. It is suggested to use `EuiCallOut` for it.
         */
  banner: _propTypes.default.node,
  /**
         * [Scrollable regions (or their children) should be focusable](https://dequeuniversity.com/rules/axe/4.0/scrollable-region-focusable)
         * to allow keyboard users to scroll the region via arrow keys.
         *
         * By default, EuiFlyoutBody's scroll overflow wrapper sets a `tabIndex` of `0`.
         * If you know your flyout body content already contains focusable children
         * that satisfy keyboard accessibility requirements, you can use this prop
         * to override this default.
         */
  scrollableTabIndex: _propTypes.default.number
};