"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiRefreshInterval = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _i18n = require("../../i18n");
var _flex = require("../../flex");
var _form = require("../../form");
var _services = require("../../../services");
var _accessibility = require("../../accessibility");
var _time_options = require("../super_date_picker/time_options");
var _react2 = require("@emotion/react");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); } /*
                                                                                                                                                                                                                                                                                                                                                                                               * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                               * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                               * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                                                                                                                               * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                                                                                                                               * Side Public License, v 1.
                                                                                                                                                                                                                                                                                                                                                                                               */
var MILLISECONDS_IN_SECOND = 1000;
var MILLISECONDS_IN_MINUTE = MILLISECONDS_IN_SECOND * 60;
var MILLISECONDS_IN_HOUR = MILLISECONDS_IN_MINUTE * 60;
var fromMilliseconds = function fromMilliseconds(milliseconds, unit) {
  var round = function round(value) {
    return parseFloat(value.toFixed(2));
  };
  if (unit === 'h' || !unit && milliseconds > MILLISECONDS_IN_HOUR) {
    return {
      units: 'h',
      value: round(milliseconds / MILLISECONDS_IN_HOUR)
    };
  }
  if (unit === 'm' || !unit && milliseconds > MILLISECONDS_IN_MINUTE) {
    return {
      units: 'm',
      value: round(milliseconds / MILLISECONDS_IN_MINUTE)
    };
  }
  return {
    units: 's',
    value: round(milliseconds / MILLISECONDS_IN_SECOND)
  };
};
var toMilliseconds = function toMilliseconds(units, value) {
  switch (units) {
    case 'h':
      return Math.round(value * MILLISECONDS_IN_HOUR);
    case 'm':
      return Math.round(value * MILLISECONDS_IN_MINUTE);
    case 's':
    default:
      return Math.round(value * MILLISECONDS_IN_SECOND);
  }
};
var getMinInterval = function getMinInterval(minInterval, unit) {
  if (!minInterval) return 0;
  var _fromMilliseconds = fromMilliseconds(minInterval, unit),
    value = _fromMilliseconds.value;
  return Math.floor(value || 0);
};
var EuiRefreshInterval = /*#__PURE__*/function (_Component) {
  _inherits(EuiRefreshInterval, _Component);
  var _super = _createSuper(EuiRefreshInterval);
  function EuiRefreshInterval() {
    var _this;
    _classCallCheck(this, EuiRefreshInterval);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "state", _objectSpread(_objectSpread({}, fromMilliseconds(_this.props.refreshInterval || 0, _this.props.intervalUnits)), {}, {
      min: getMinInterval(_this.props.minInterval, _this.props.intervalUnits)
    }));
    _defineProperty(_assertThisInitialized(_this), "generateId", (0, _services.htmlIdGenerator)());
    _defineProperty(_assertThisInitialized(_this), "legendId", _this.generateId());
    _defineProperty(_assertThisInitialized(_this), "refreshSelectionId", _this.generateId());
    _defineProperty(_assertThisInitialized(_this), "onValueChange", function (event) {
      var sanitizedValue = parseFloat(event.target.value);
      _this.setState({
        value: isNaN(sanitizedValue) ? '' : sanitizedValue
      }, _this.applyRefreshInterval);
    });
    _defineProperty(_assertThisInitialized(_this), "onUnitsChange", function (event) {
      var units = event.target.value;
      _this.setState({
        units: units,
        min: getMinInterval(_this.props.minInterval, units)
      }, _this.applyRefreshInterval);
    });
    _defineProperty(_assertThisInitialized(_this), "startRefresh", function () {
      var onRefreshChange = _this.props.onRefreshChange;
      var _this$state = _this.state,
        value = _this$state.value,
        units = _this$state.units;
      if (value !== '' && value > 0 && onRefreshChange !== undefined) {
        onRefreshChange({
          refreshInterval: toMilliseconds(units, value),
          intervalUnits: units,
          isPaused: false
        });
      }
    });
    _defineProperty(_assertThisInitialized(_this), "handleKeyDown", function (_ref) {
      var key = _ref.key;
      if (key === 'Enter') {
        _this.startRefresh();
      }
    });
    _defineProperty(_assertThisInitialized(_this), "applyRefreshInterval", function () {
      var _this$props = _this.props,
        onRefreshChange = _this$props.onRefreshChange,
        isPaused = _this$props.isPaused,
        minInterval = _this$props.minInterval;
      var _this$state2 = _this.state,
        units = _this$state2.units,
        value = _this$state2.value;
      if (value === '') {
        return;
      }
      if (!onRefreshChange) {
        return;
      }
      var refreshInterval = Math.max(toMilliseconds(units, value), minInterval || 0);
      onRefreshChange({
        refreshInterval: refreshInterval,
        intervalUnits: units,
        isPaused: refreshInterval <= 0 ? true : !!isPaused
      });
    });
    _defineProperty(_assertThisInitialized(_this), "toggleRefresh", function () {
      var _this$props2 = _this.props,
        onRefreshChange = _this$props2.onRefreshChange,
        isPaused = _this$props2.isPaused;
      var _this$state3 = _this.state,
        units = _this$state3.units,
        value = _this$state3.value;
      if (!onRefreshChange || value === '') {
        return;
      }
      onRefreshChange({
        refreshInterval: toMilliseconds(units, value),
        intervalUnits: units,
        isPaused: !isPaused
      });
    });
    _defineProperty(_assertThisInitialized(_this), "renderScreenReaderText", function (refreshUnitsOptions) {
      var isPaused = _this.props.isPaused;
      var _this$state4 = _this.state,
        value = _this$state4.value,
        units = _this$state4.units;
      var options = refreshUnitsOptions.find(function (_ref2) {
        var value = _ref2.value;
        return value === units;
      });
      var optionText = options ? options.text : '';
      var fullDescription = isPaused ? (0, _react2.jsx)(_i18n.EuiI18n, {
        token: "euiRefreshInterval.fullDescriptionOff",
        default: "Refresh is off, interval set to {optionValue} {optionText}.",
        values: {
          optionValue: value,
          optionText: optionText
        }
      }) : (0, _react2.jsx)(_i18n.EuiI18n, {
        token: "euiRefreshInterval.fullDescriptionOn",
        default: "Refresh is on, interval set to {optionValue} {optionText}.",
        values: {
          optionValue: value,
          optionText: optionText
        }
      });
      return (0, _react2.jsx)(_accessibility.EuiScreenReaderOnly, null, (0, _react2.jsx)("p", {
        id: _this.refreshSelectionId
      }, fullDescription));
    });
    return _this;
  }
  _createClass(EuiRefreshInterval, [{
    key: "render",
    value: function render() {
      var _this2 = this;
      var isPaused = this.props.isPaused;
      var _this$state5 = this.state,
        value = _this$state5.value,
        units = _this$state5.units,
        min = _this$state5.min;
      return (0, _react2.jsx)(_time_options.RenderI18nTimeOptions, null, function (_ref3) {
        var refreshUnitsOptions = _ref3.refreshUnitsOptions;
        return (0, _react2.jsx)("fieldset", {
          className: "euiQuickSelectPopover__panel"
        }, (0, _react2.jsx)(_flex.EuiFlexGroup, {
          alignItems: "center",
          gutterSize: "s",
          responsive: false,
          wrap: true
        }, (0, _react2.jsx)(_flex.EuiFlexItem, {
          grow: false
        }, (0, _react2.jsx)(_form.EuiSwitch, {
          "data-test-subj": "superDatePickerToggleRefreshButton",
          "aria-describedby": _this2.refreshSelectionId,
          checked: !isPaused,
          onChange: _this2.toggleRefresh,
          compressed: true,
          label: (0, _react2.jsx)(_form.EuiFormLabel, {
            type: "legend",
            id: _this2.legendId
          }, (0, _react2.jsx)(_i18n.EuiI18n, {
            token: "euiRefreshInterval.legend",
            default: "Refresh every"
          }))
        })), (0, _react2.jsx)(_flex.EuiFlexItem, {
          style: {
            minWidth: 60
          }
        }, (0, _react2.jsx)(_form.EuiFieldNumber, {
          compressed: true,
          fullWidth: true,
          value: value,
          min: min,
          onChange: _this2.onValueChange,
          onKeyDown: _this2.handleKeyDown,
          isInvalid: !isPaused && (value === '' || value <= 0),
          disabled: isPaused,
          "aria-label": "Refresh interval value",
          "aria-describedby": "".concat(_this2.refreshSelectionId, " ").concat(_this2.legendId),
          "data-test-subj": "superDatePickerRefreshIntervalInput"
        })), (0, _react2.jsx)(_flex.EuiFlexItem, {
          style: {
            minWidth: 100
          },
          grow: 2
        }, (0, _react2.jsx)(_form.EuiSelect, {
          compressed: true,
          fullWidth: true,
          "aria-label": "Refresh interval units",
          "aria-describedby": "".concat(_this2.refreshSelectionId, " ").concat(_this2.legendId),
          value: units,
          disabled: isPaused,
          options: refreshUnitsOptions,
          onChange: _this2.onUnitsChange,
          onKeyDown: _this2.handleKeyDown,
          "data-test-subj": "superDatePickerRefreshIntervalUnitsSelect"
        }))), _this2.renderScreenReaderText(refreshUnitsOptions));
      });
    }
  }]);
  return EuiRefreshInterval;
}(_react.Component);
exports.EuiRefreshInterval = EuiRefreshInterval;
_defineProperty(EuiRefreshInterval, "defaultProps", {
  isPaused: true,
  refreshInterval: 1000,
  minInterval: 0
});
EuiRefreshInterval.propTypes = {
  /**
     * Is refresh paused or running.
     */
  isPaused: _propTypes.default.bool,
  /**
     * Refresh interval in milliseconds.
     */
  refreshInterval: _propTypes.default.number,
  /**
     * Allows specifying a minimum interval in milliseconds
     */
  minInterval: _propTypes.default.number,
  /**
     * By default, refresh interval units will be rounded up to next largest unit of time
     * (for example, 90 seconds will become 2m).
     *
     * If you do not want this behavior, you can manually control the rendered unit via this prop.
     */
  intervalUnits: _propTypes.default.oneOf(["s", "m", "h"]),
  /**
     * Passes back the updated state of `isPaused`, `refreshInterval`, and `intervalUnits`.
     */
  onRefreshChange: _propTypes.default.func.isRequired
};