"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiDataGridHeaderRow = void 0;
var _classnames = _interopRequireDefault(require("classnames"));
var _react = _interopRequireWildcard(require("react"));
var _data_grid_control_header_cell = require("./data_grid_control_header_cell");
var _data_grid_header_cell = require("./data_grid_header_cell");
var _data_grid_types = require("../../data_grid_types");
var _react2 = require("@emotion/react");
var _excluded = ["className", "data-test-subj", "leadingControlColumns", "trailingControlColumns", "columns", "columnWidths", "defaultColumnWidth", "setColumnWidth", "setVisibleColumns", "switchColumnPos", "sorting", "schema", "schemaDetectors"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
var EuiDataGridHeaderRow = /*#__PURE__*/(0, _react.memo)( /*#__PURE__*/(0, _react.forwardRef)(function (props, ref) {
  var className = props.className,
    _dataTestSubj = props['data-test-subj'],
    _props$leadingControl = props.leadingControlColumns,
    leadingControlColumns = _props$leadingControl === void 0 ? _data_grid_types.emptyControlColumns : _props$leadingControl,
    _props$trailingContro = props.trailingControlColumns,
    trailingControlColumns = _props$trailingContro === void 0 ? _data_grid_types.emptyControlColumns : _props$trailingContro,
    columns = props.columns,
    columnWidths = props.columnWidths,
    defaultColumnWidth = props.defaultColumnWidth,
    setColumnWidth = props.setColumnWidth,
    setVisibleColumns = props.setVisibleColumns,
    switchColumnPos = props.switchColumnPos,
    sorting = props.sorting,
    schema = props.schema,
    schemaDetectors = props.schemaDetectors,
    rest = _objectWithoutProperties(props, _excluded);
  var classes = (0, _classnames.default)('euiDataGridHeader', className);
  var dataTestSubj = (0, _classnames.default)('dataGridHeader', _dataTestSubj);
  return (0, _react2.jsx)("div", _extends({
    role: "row",
    ref: ref,
    className: classes,
    "data-test-subj": dataTestSubj
  }, rest), leadingControlColumns.map(function (controlColumn, index) {
    return (0, _react2.jsx)(_data_grid_control_header_cell.EuiDataGridControlHeaderCell, {
      key: controlColumn.id,
      index: index,
      controlColumn: controlColumn
    });
  }), columns.map(function (column, index) {
    return (0, _react2.jsx)(_data_grid_header_cell.EuiDataGridHeaderCell, {
      key: column.id,
      index: index + leadingControlColumns.length,
      column: column,
      columns: columns,
      columnWidths: columnWidths,
      defaultColumnWidth: defaultColumnWidth,
      setColumnWidth: setColumnWidth,
      setVisibleColumns: setVisibleColumns,
      switchColumnPos: switchColumnPos,
      sorting: sorting,
      schema: schema,
      schemaDetectors: schemaDetectors
    });
  }), trailingControlColumns.map(function (controlColumn, index) {
    return (0, _react2.jsx)(_data_grid_control_header_cell.EuiDataGridControlHeaderCell, {
      key: controlColumn.id,
      index: index + leadingControlColumns.length + columns.length,
      controlColumn: controlColumn
    });
  }));
}));
exports.EuiDataGridHeaderRow = EuiDataGridHeaderRow;
EuiDataGridHeaderRow.displayName = 'EuiDataGridHeaderRow';