"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiContextMenuItemStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
                                                                                                                                                                                                                                                                                           * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                           * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                           * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                           * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                           * Side Public License, v 1.
                                                                                                                                                                                                                                                                                           */
var _ref = process.env.NODE_ENV === "production" ? {
  name: "4ak4s8-euiContextMenuItem__arrow",
  styles: "align-self:flex-end;label:euiContextMenuItem__arrow;"
} : {
  name: "4ak4s8-euiContextMenuItem__arrow",
  styles: "align-self:flex-end;label:euiContextMenuItem__arrow;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref2 = process.env.NODE_ENV === "production" ? {
  name: "o1gg22-euiContextMenuItem__text",
  styles: "flex-grow:1;overflow:hidden;label:euiContextMenuItem__text;"
} : {
  name: "o1gg22-euiContextMenuItem__text",
  styles: "flex-grow:1;overflow:hidden;label:euiContextMenuItem__text;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref3 = process.env.NODE_ENV === "production" ? {
  name: "1lzohcs-euiContextMenu__icon",
  styles: "flex-shrink:0;label:euiContextMenu__icon;"
} : {
  name: "1lzohcs-euiContextMenu__icon",
  styles: "flex-shrink:0;label:euiContextMenu__icon;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref4 = process.env.NODE_ENV === "production" ? {
  name: "1msaet2-bottom",
  styles: "align-items:flex-end;label:bottom;"
} : {
  name: "1msaet2-bottom",
  styles: "align-items:flex-end;label:bottom;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref5 = process.env.NODE_ENV === "production" ? {
  name: "1gnwbvd-top",
  styles: "align-items:flex-start;label:top;"
} : {
  name: "1gnwbvd-top",
  styles: "align-items:flex-start;label:top;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref6 = process.env.NODE_ENV === "production" ? {
  name: "8391db-center",
  styles: "align-items:center;label:center;"
} : {
  name: "8391db-center",
  styles: "align-items:center;label:center;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiContextMenuItemStyles = function euiContextMenuItemStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiContextMenuItem: /*#__PURE__*/(0, _react.css)("display:flex;gap:", euiTheme.size.s, ";", (0, _global_styling.logicalCSS)('width', '100%'), " ", (0, _global_styling.logicalTextAlignCSS)('left'), " color:", euiTheme.colors.text, ";outline-offset:-", euiTheme.focus.width, ";&:where(a, button):not(:disabled){&:hover,&:focus{text-decoration:underline;}&:focus{background-color:", euiTheme.focus.backgroundColor, ";}};label:euiContextMenuItem;"),
    disabled: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.disabledText, ";cursor:default;;label:disabled;"),
    layoutAlign: {
      center: _ref6,
      top: _ref5,
      bottom: _ref4
    },
    sizes: {
      m: /*#__PURE__*/(0, _react.css)("padding:", euiTheme.size.m, ";;label:m;"),
      s: /*#__PURE__*/(0, _react.css)("padding:", euiTheme.size.s, ";;label:s;")
    },
    // Children
    euiContextMenu__icon: _ref3,
    text: {
      euiContextMenuItem__text: _ref2,
      s: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiFontSize)(euiThemeContext, 's'), ";;label:s;")
    },
    euiContextMenuItem__arrow: _ref
  };
};
exports.euiContextMenuItemStyles = euiContextMenuItemStyles;