"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SIZES = exports.LAYOUT_ALIGN = exports.EuiContextMenuItem = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _href_validator = require("../../services/security/href_validator");
var _common = require("../common");
var _icon = require("../icon");
var _tool_tip = require("../tool_tip");
var _context_menu_item = require("./context_menu_item.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "className", "hasPanel", "icon", "buttonRef", "disabled", "layoutAlign", "toolTipContent", "toolTipProps", "href", "target", "rel", "size"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
var SIZES = ['s', 'm'];
exports.SIZES = SIZES;
var layoutAlignToClassNames = {
  center: null,
  top: 'euiContextMenu__itemLayout--top',
  bottom: 'euiContextMenu__itemLayout--bottom'
};
var LAYOUT_ALIGN = (0, _common.keysOf)(layoutAlignToClassNames);
exports.LAYOUT_ALIGN = LAYOUT_ALIGN;
var EuiContextMenuItem = function EuiContextMenuItem(_ref) {
  var children = _ref.children,
    className = _ref.className,
    hasPanel = _ref.hasPanel,
    icon = _ref.icon,
    buttonRef = _ref.buttonRef,
    _disabled = _ref.disabled,
    _ref$layoutAlign = _ref.layoutAlign,
    layoutAlign = _ref$layoutAlign === void 0 ? 'center' : _ref$layoutAlign,
    toolTipContent = _ref.toolTipContent,
    toolTipProps = _ref.toolTipProps,
    href = _ref.href,
    target = _ref.target,
    rel = _ref.rel,
    _ref$size = _ref.size,
    size = _ref$size === void 0 ? 'm' : _ref$size,
    rest = _objectWithoutProperties(_ref, _excluded);
  var isHrefValid = !href || (0, _href_validator.validateHref)(href);
  var disabled = _disabled || !isHrefValid;
  var classes = (0, _classnames.default)('euiContextMenuItem', className);
  var styles = (0, _services.useEuiMemoizedStyles)(_context_menu_item.euiContextMenuItemStyles);
  var cssStyles = [styles.euiContextMenuItem, styles.sizes[size], styles.layoutAlign[layoutAlign], disabled && styles.disabled];
  var iconInstance = icon && (typeof icon === 'string' ? (0, _react2.jsx)(_icon.EuiIcon, {
    type: icon,
    size: "m",
    className: "euiContextMenu__icon",
    css: styles.euiContextMenu__icon,
    color: "inherit" // forces the icon to inherit its parent color
  }) :
  // Assume it's already an instance of an icon.
  (0, _services.cloneElementWithCss)(icon, {
    css: styles.euiContextMenu__icon
  }));
  var arrow = hasPanel && (0, _react2.jsx)(_icon.EuiIcon, {
    type: "arrowRight",
    size: "m",
    className: "euiContextMenu__arrow",
    css: styles.euiContextMenuItem__arrow
  });
  var textStyles = [styles.text.euiContextMenuItem__text, size === 's' && styles.text.s];
  var buttonContent = (0, _react2.jsx)(_react.default.Fragment, null, iconInstance, (0, _react2.jsx)("span", {
    className: "euiContextMenuItem__text",
    css: textStyles
  }, children), arrow);
  var button;
  // <a> elements don't respect the `disabled` attribute. So if we're disabled, we'll just pretend
  // this is a button and piggyback off its disabled styles.
  if (href && !disabled) {
    var secureRel = (0, _services.getSecureRelForTarget)({
      href: href,
      target: target,
      rel: rel
    });
    button = (0, _react2.jsx)("a", _extends({
      css: cssStyles,
      className: classes,
      href: href,
      target: target,
      rel: secureRel,
      ref: buttonRef
    }, rest), buttonContent);
  } else if (href || rest.onClick || toolTipContent) {
    button = (0, _react2.jsx)("button", _extends({
      disabled: disabled,
      css: cssStyles,
      className: classes,
      type: "button",
      ref: buttonRef
    }, rest), buttonContent);
  } else {
    button = (0, _react2.jsx)("div", _extends({
      css: cssStyles,
      className: classes,
      ref: buttonRef
    }, rest), buttonContent);
  }
  if (toolTipContent) {
    var anchorClasses = (0, _classnames.default)('eui-displayBlock', toolTipProps === null || toolTipProps === void 0 ? void 0 : toolTipProps.anchorClassName);
    return (0, _react2.jsx)(_tool_tip.EuiToolTip, _extends({
      position: "right"
    }, toolTipProps, {
      anchorClassName: anchorClasses,
      content: toolTipContent
    }), button);
  } else {
    return button;
  }
};
exports.EuiContextMenuItem = EuiContextMenuItem;
EuiContextMenuItem.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  icon: _propTypes.default.oneOfType([_propTypes.default.element.isRequired, _propTypes.default.string.isRequired, _propTypes.default.any.isRequired]),
  hasPanel: _propTypes.default.bool,
  disabled: _propTypes.default.bool,
  onClick: _propTypes.default.func,
  buttonRef: _propTypes.default.any,
  /**
     * Required if using a tooltip. Add an optional tooltip on hover
     */
  toolTipContent: _propTypes.default.node,
  /**
     * Optional configuration to pass to the underlying [EuiToolTip](/#/display/tooltip).
     * Accepts any prop that EuiToolTip does, except for `content` and `children`.
     */
  toolTipProps: _propTypes.default.any,
  href: _propTypes.default.string,
  target: _propTypes.default.string,
  rel: _propTypes.default.string,
  /**
     * How to align icon with content of button
     */
  layoutAlign: _propTypes.default.oneOf(["center", "top", "bottom"]),
  /**
     * Reduce the size to `s` when in need of a more compressed menu
     */
  size: _propTypes.default.any
};