"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiCollapsibleNavAccordion = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../../services");
var _accordion = require("../../accordion");
var _collapsible_nav_item = require("./collapsible_nav_item");
var _collapsible_nav_link = require("./collapsible_nav_link");
var _collapsible_nav_accordion = require("./collapsible_nav_accordion.styles");
var _react2 = require("@emotion/react");
var _excluded = ["id", "className", "items", "isSubItem", "isSelected", "accordionProps", "buttonContent", "children"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
/**
 * Internal nav accordion component.
 *
 * Renders children as either a nav link or any number/nesting of more nav accordions.
 * Triggering the open/closed state is handled only by the accordion `arrow` for
 * UX consistency, as accordion/nav titles can be their own links to pages.
 */
var EuiCollapsibleNavAccordion = function EuiCollapsibleNavAccordion(_ref) {
  var _accordionProps$arrow;
  var id = _ref.id,
    className = _ref.className,
    items = _ref.items,
    isSubItem = _ref.isSubItem,
    isSelected = _ref.isSelected,
    accordionProps = _ref.accordionProps,
    buttonContent = _ref.buttonContent,
    _children = _ref.children,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = (0, _classnames.default)('euiCollapsibleNavAccordion', className);
  var groupID = (0, _services.useGeneratedHtmlId)({
    conditionalId: id
  });
  var styles = (0, _services.useEuiMemoizedStyles)(_collapsible_nav_accordion.euiCollapsibleNavAccordionStyles);
  var cssStyles = [styles.euiCollapsibleNavAccordion, isSubItem ? styles.isSubItem : styles.isTopItem, isSelected && styles.isSelected, accordionProps === null || accordionProps === void 0 ? void 0 : accordionProps.css];
  return (0, _react2.jsx)(_accordion.EuiAccordion, _extends({
    id: groupID,
    className: classes,
    initialIsOpen: isSelected,
    buttonContent: (0, _react2.jsx)(_collapsible_nav_link.EuiCollapsibleNavLink, {
      isSelected: isSelected,
      isSubItem: isSubItem,
      isInteractive: false
    }, buttonContent),
    arrowDisplay: "right"
  }, rest, accordionProps, {
    css: cssStyles,
    arrowProps: _objectSpread(_objectSpread({
      iconSize: 's'
    }, accordionProps === null || accordionProps === void 0 ? void 0 : accordionProps.arrowProps), {}, {
      css: [styles.euiCollapsibleNavAccordion__arrow, accordionProps === null || accordionProps === void 0 ? void 0 : (_accordionProps$arrow = accordionProps.arrowProps) === null || _accordionProps$arrow === void 0 ? void 0 : _accordionProps$arrow.css]
    })
  }), (0, _react2.jsx)(_collapsible_nav_item.EuiCollapsibleNavSubItems, {
    items: items,
    isSubItem: isSubItem,
    className: "euiCollapsibleNavAccordion__children"
  }));
};
exports.EuiCollapsibleNavAccordion = EuiCollapsibleNavAccordion;
EuiCollapsibleNavAccordion.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  /**
       * Highlights whether an item is currently selected, e.g.
       * if the user is on the same page as the nav link
       */
  isSelected: _propTypes.default.bool,
  /**
     * Determines whether the item should render as a top-level nav item
     * or a nested nav subitem. Set internally by EUI
     */
  isSubItem: _propTypes.default.bool,
  buttonContent: _propTypes.default.node.isRequired
};