"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiCollapsedNavItemTooltipStyles = exports.euiCollapsedNavButtonStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../../../global_styling");
var _collapsible_nav_item = require("../collapsible_nav_item.styles");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
                                                                                                                                                                                                                                                                                           * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                           * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                           * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                           * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                           * Side Public License, v 1.
                                                                                                                                                                                                                                                                                           */
var euiCollapsedNavButtonStyles = function euiCollapsedNavButtonStyles(euiThemeContext) {
  var sharedStyles = (0, _collapsible_nav_item.euiCollapsibleNavItemVariables)(euiThemeContext);
  return {
    euiCollapsedNavButton: /*#__PURE__*/(0, _react.css)("display:flex;margin:", sharedStyles.padding, ";&.euiButtonIcon:hover{transform:none;};label:euiCollapsedNavButton;"),
    isSelected: /*#__PURE__*/(0, _react.css)("&,&:hover,&:focus{background-color:", sharedStyles.backgroundSelectedColor, ";};label:isSelected;")
  };
};
exports.euiCollapsedNavButtonStyles = euiCollapsedNavButtonStyles;
var _ref = process.env.NODE_ENV === "production" ? {
  name: "1mkqgn7-hidden",
  styles: "display:none;label:hidden;"
} : {
  name: "1mkqgn7-hidden",
  styles: "display:none;label:hidden;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiCollapsedNavItemTooltipStyles = function euiCollapsedNavItemTooltipStyles(_ref2) {
  var euiTheme = _ref2.euiTheme;
  return {
    euiCollapsedNavItemTooltip: /*#__PURE__*/(0, _react.css)(";label:euiCollapsedNavItemTooltip;"),
    // Bring the tooltip closer to the nav - it's a little too far otherwise
    left: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('margin-left', "-".concat(euiTheme.size.m)), ";;label:left;"),
    right: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('margin-right', "-".concat(euiTheme.size.m)), ";;label:right;"),
    // If the item has a popover and the popover is open, we don't want the
    // tooltip to appear if so - the popover already renders the item title
    hidden: _ref
  };
};
exports.euiCollapsedNavItemTooltipStyles = euiCollapsedNavItemTooltipStyles;