"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiCodeSyntaxVariables = void 0;
var _services = require("../../services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var visColors = (0, _services.euiPaletteColorBlind)();

// These variables are computationally expensive - do not call them outside `useEuiMemoizedStyles`
var euiCodeSyntaxVariables = function euiCodeSyntaxVariables(_ref) {
  var euiTheme = _ref.euiTheme;
  var backgroundColor = euiTheme.colors.lightestShade;
  return {
    backgroundColor: backgroundColor,
    color: (0, _services.makeHighContrastColor)(euiTheme.colors.text)(backgroundColor),
    inlineCodeColor: (0, _services.makeHighContrastColor)(visColors[3])(backgroundColor),
    selectedBackgroundColor: 'inherit',
    commentColor: (0, _services.makeHighContrastColor)(euiTheme.colors.subduedText)(backgroundColor),
    selectorTagColor: 'inherit',
    stringColor: (0, _services.makeHighContrastColor)(visColors[2])(backgroundColor),
    tagColor: (0, _services.makeHighContrastColor)(visColors[1])(backgroundColor),
    nameColor: (0, _services.makeHighContrastColor)(visColors[1])(backgroundColor),
    numberColor: (0, _services.makeHighContrastColor)(visColors[0])(backgroundColor),
    keywordColor: (0, _services.makeHighContrastColor)(visColors[3])(backgroundColor),
    functionTitleColor: 'inherit',
    typeColor: (0, _services.makeHighContrastColor)(visColors[1])(backgroundColor),
    attributeColor: 'inherit',
    symbolColor: (0, _services.makeHighContrastColor)(visColors[9])(backgroundColor),
    paramsColor: 'inherit',
    metaColor: (0, _services.makeHighContrastColor)(euiTheme.colors.subduedText)(backgroundColor),
    titleColor: (0, _services.makeHighContrastColor)(visColors[7])(backgroundColor),
    sectionColor: (0, _services.makeHighContrastColor)(visColors[9])(backgroundColor),
    additionColor: (0, _services.makeHighContrastColor)(visColors[0])(backgroundColor),
    deletionColor: (0, _services.makeHighContrastColor)(euiTheme.colors.danger)(backgroundColor),
    selectorClassColor: 'inherit',
    selectorIdColor: 'inherit',
    get tokensCss() {
      return "\n  .token.punctuation:not(.interpolation-punctuation):not([class*='attr-']) {\n    opacity: .7;\n  }\n\n  .token.comment,\n  .token.prolog,\n  .token.doctype,\n  .token.cdata,\n  .token.coord,\n  .token.blockquote {\n    color: ".concat(this.commentColor, ";\n    font-style: italic;\n  }\n\n  .token.selector {\n    color: ").concat(this.selectorTagColor, ";\n  }\n\n  .token.string,\n  .token.interpolation,\n  .token.interpolation-punctuation,\n  .token.doc-comment .token.keyword,\n  .token.attr-value,\n  .token.url .token.content {\n    color: ").concat(this.stringColor, ";\n  }\n\n  .token.number,\n  .token.boolean,\n  .token.keyword.nil,\n  .token.regex,\n  .token.variable,\n  .token.unit,\n  .token.hexcode,\n  .token.attr-name,\n  .token.attr-equals {\n    color: ").concat(this.numberColor, ";\n  }\n\n  .token.atrule .token.rule,\n  .token.keyword {\n    color: ").concat(this.keywordColor, ";\n  }\n\n  .token.function {\n    color: ").concat(this.functionTitleColor, ";\n  }\n\n  .token.tag {\n    color: ").concat(this.tagColor, ";\n  }\n\n  .token.class-name {\n    color: ").concat(this.typeColor, ";\n  }\n\n  .token.property {\n    color: ").concat(this.attributeColor, ";\n  }\n\n  .token.console,\n  .token.list-punctuation,\n  .token.url-reference,\n  .token.url .token.url {\n    color: ").concat(this.symbolColor, ";\n  }\n\n  .token.paramater {\n    color: ").concat(this.paramsColor, ";\n  }\n\n  .token.meta,\n  .token.important {\n    color: ").concat(this.metaColor, ";\n  }\n\n  .token.title {\n    color: ").concat(this.titleColor, ";\n  }\n\n  .token.section {\n    color: ").concat(this.sectionColor, ";\n  }\n\n  .token.prefix.inserted,\n  .token.prefix.deleted {\n    padding-inline-start: -").concat(euiTheme.size.xs, ";\n    margin-inline-start:  -").concat(euiTheme.size.xs, ";\n  }\n\n  .token.prefix.inserted {\n    box-shadow: -").concat(euiTheme.size.xs, " 0 ").concat(this.additionColor, ";\n    color: ").concat(this.additionColor, ";\n  }\n\n  .token.prefix.deleted {\n    box-shadow: -").concat(euiTheme.size.xs, " 0 ").concat(this.deletionColor, ";\n    color: ").concat(this.deletionColor, ";\n  }\n\n  .token.selector .token.class {\n    color: ").concat(this.selectorClassColor, ";\n  }\n\n  .token.selector .token.id {\n    color: ").concat(this.selectorIdColor, ";\n  }\n\n  .token.italic {\n    font-style: italic;\n  }\n\n  .token.important,\n  .token.bold {\n    font-weight: ").concat(euiTheme.font.weight.bold, ";\n  }\n\n  .token.url-reference,\n  .token.url .token.url {\n    text-decoration: underline;\n  }\n\n  .token.entity {\n    cursor: help;\n  }");
    }
  };
};
exports.euiCodeSyntaxVariables = euiCodeSyntaxVariables;