"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiCodeBlockAnnotationsStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiCodeBlockAnnotationsStyles = function euiCodeBlockAnnotationsStyles(_ref) {
  var euiTheme = _ref.euiTheme;
  var buttonIconSize = (0, _global_styling.mathWithUnits)(euiTheme.size.base, function (x) {
    return x - 1.5;
  });
  return {
    euiCodeBlockAnnotation: /*#__PURE__*/(0, _react.css)("position:absolute;", (0, _global_styling.logicalCSS)('right', 0), " ", (0, _global_styling.logicalCSS)('top', '50%'), " transform:translate(50%, -50%);line-height:1;;label:euiCodeBlockAnnotation;"),
    euiCodeBlockAnnotation__buttonIcon: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalSizeCSS)(buttonIconSize), " display:flex;align-items:center;justify-content:center;background-color:", euiTheme.colors.primary, ";border-radius:50%;;label:euiCodeBlockAnnotation__buttonIcon;")
  };
};
exports.euiCodeBlockAnnotationsStyles = euiCodeBlockAnnotationsStyles;