"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiCodeStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
var _code_syntax = require("./code_syntax.styles");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
                                                                                                                                                                                                                                                                                           * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                           * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                           * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                           * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                           * Side Public License, v 1.
                                                                                                                                                                                                                                                                                           */
var _ref = process.env.NODE_ENV === "production" ? {
  name: "gfiv3z-transparentBackground",
  styles: "background:transparent;label:transparentBackground;"
} : {
  name: "gfiv3z-transparentBackground",
  styles: "background:transparent;label:transparentBackground;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiCodeStyles = function euiCodeStyles(euiThemeContext) {
  var codeSyntaxVariables = (0, _code_syntax.euiCodeSyntaxVariables)(euiThemeContext);
  var euiTheme = euiThemeContext.euiTheme;
  return {
    /*
     * 1. Size the code against the text its embedded within.
     */
    euiCode: /*#__PURE__*/(0, _react.css)("font-family:", euiTheme.font.familyCode, ";font-size:0.9em;", (0, _global_styling.logicalShorthandCSS)('padding', '0.2em 0.5em'), "background:", codeSyntaxVariables.backgroundColor, ";border-radius:", euiTheme.border.radius.small, ";font-weight:", euiTheme.font.weight.bold, ";color:", codeSyntaxVariables.inlineCodeColor, ";", codeSyntaxVariables.tokensCss, ";;label:euiCode;"),
    transparentBackground: _ref
  };
};
exports.euiCodeStyles = euiCodeStyles;