"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiButtonGroupButtonStyles = exports._compressedButtonFocusColors = void 0;
var _react = require("@emotion/react");
var _services = require("../../../services");
var _global_styling = require("../../../global_styling");
var _button = require("../../../themes/amsterdam/global_styling/mixins/button");
var _accessibility = require("../../accessibility");
var _form = require("../../form/form.styles");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }
function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
                                                                                                                                                                                                                                                                                           * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                           * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                           * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                           * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                           * Side Public License, v 1.
                                                                                                                                                                                                                                                                                           */
var _ref = process.env.NODE_ENV === "production" ? {
  name: "nwv4a2-tooltipWrapper",
  styles: "overflow:hidden;label:tooltipWrapper;"
} : {
  name: "nwv4a2-tooltipWrapper",
  styles: "overflow:hidden;label:tooltipWrapper;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref2 = process.env.NODE_ENV === "production" ? {
  name: "1u3o7zy-hasToolTip",
  styles: "border-radius:inherit;label:hasToolTip;"
} : {
  name: "1u3o7zy-hasToolTip",
  styles: "border-radius:inherit;label:hasToolTip;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiButtonGroupButtonStyles = function euiButtonGroupButtonStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var _euiFormVariables = (0, _form.euiFormVariables)(euiThemeContext),
    controlCompressedHeight = _euiFormVariables.controlCompressedHeight,
    controlCompressedBorderRadius = _euiFormVariables.controlCompressedBorderRadius;
  var compressedButtonHeight = (0, _global_styling.mathWithUnits)([controlCompressedHeight, euiTheme.border.width.thin], function (x, y) {
    return x - y * 2;
  });
  var uncompressedBorderRadii = function uncompressedBorderRadii(radiusSize) {
    return "\n    border-radius: 0;\n\n    &:first-child {\n      ".concat((0, _global_styling.logicalShorthandCSS)('border-radius', "".concat(radiusSize, " 0 0 ").concat(radiusSize)), "\n    }\n\n    &:last-child {\n      ").concat((0, _global_styling.logicalShorthandCSS)('border-radius', "0 ".concat(radiusSize, " ").concat(radiusSize, " 0")), "\n    }\n  ");
  };
  return {
    // Base
    euiButtonGroupButton: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('min-width', 0), " flex-shrink:1;flex-grow:0;", _global_styling.euiCanAnimate, "{transition:background-color ", euiTheme.animation.normal, " ease-in-out,color ", euiTheme.animation.normal, " ease-in-out;};label:euiButtonGroupButton;"),
    iconOnly: /*#__PURE__*/(0, _react.css)("padding-inline:", euiTheme.size.s, ";;label:iconOnly;"),
    // Sizes
    uncompressed: {
      uncompressed: /*#__PURE__*/(0, _react.css)("&:is(.euiButtonGroupButton-isSelected){font-weight:", euiTheme.font.weight.bold, ";}&:focus-visible{", (0, _global_styling.euiOutline)(euiThemeContext, 'inset', euiTheme.colors.fullShade), ";};label:uncompressed;"),
      get borders() {
        var selectors = '.euiButtonGroupButton-isSelected, .euiButtonGroup__tooltipWrapper-isSelected';
        var selectedColor = (0, _services.transparentize)(euiTheme.colors.emptyShade, 0.2);
        var unselectedColor = (0, _services.transparentize)(euiTheme.colors.fullShade, 0.1);
        var borderWidth = euiTheme.border.width.thin;

        // "Borders" between buttons should be present between two of the same colored buttons,
        // and absent between selected vs non-selected buttons (different colors)
        return "\n          &:not(".concat(selectors, ") + *:not(").concat(selectors, ") {\n            box-shadow: -").concat(borderWidth, " 0 0 0 ").concat(unselectedColor, ";\n          }\n          &:is(").concat(selectors, ") + *:is(").concat(selectors, ") {\n            box-shadow: -").concat(borderWidth, " 0 0 0 ").concat(selectedColor, ";\n          }\n        ");
      },
      get s() {
        return /*#__PURE__*/(0, _react.css)(this.borders, " ", uncompressedBorderRadii(euiTheme.border.radius.small), ";;label:s;");
      },
      get m() {
        return /*#__PURE__*/(0, _react.css)(this.borders, " ", uncompressedBorderRadii(euiTheme.border.radius.medium), ";;label:m;");
      },
      hasToolTip: _ref2
    },
    compressed: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('height', compressedButtonHeight), " line-height:", compressedButtonHeight, ";padding:", (0, _global_styling.mathWithUnits)(euiTheme.border.width.thin, function (x) {
      return x * 2;
    }), ";background-clip:content-box;border-radius:", (0, _global_styling.mathWithUnits)([controlCompressedBorderRadius, euiTheme.border.width.thin], function (x, y) {
      return x + y;
    }), ";font-weight:", euiTheme.font.weight.regular, ";&:is(.euiButtonGroupButton-isSelected){font-weight:", euiTheme.font.weight.semiBold, ";};label:compressed;"),
    // States
    disabledAndSelected: /*#__PURE__*/(0, _react.css)("color:", (0, _services.makeDisabledContrastColor)(euiTheme.colors.disabledText)(euiTheme.colors.disabled), ";background-color:", euiTheme.colors.disabled, ";;label:disabledAndSelected;"),
    // Tooltip anchor wrapper
    tooltipWrapper: _ref,
    // Content wrapper
    content: {
      euiButtonGroupButton__content: /*#__PURE__*/(0, _react.css)(";label:euiButtonGroupButton__content;"),
      compressed: /*#__PURE__*/(0, _react.css)("padding-inline:", euiTheme.size.s, ";;label:compressed;")
    },
    // Text wrapper
    text: {
      euiButtonGroupButton__text: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiTextShift)('bold', 'data-text', euiTheme), ";;label:euiButtonGroupButton__text;"),
      euiButtonGroupButton__iconOnly: /*#__PURE__*/(0, _react.css)((0, _accessibility.euiScreenReaderOnly)(), ";;label:euiButtonGroupButton__iconOnly;")
    }
  };
};
exports.euiButtonGroupButtonStyles = euiButtonGroupButtonStyles;
var _compressedButtonFocusColors = function _compressedButtonFocusColors(euiThemeContext) {
  var colors = [].concat(_toConsumableArray(_button.BUTTON_COLORS), ['disabled']);
  return colors.reduce(function (acc, color) {
    var _euiButtonFillColor = (0, _button.euiButtonFillColor)(euiThemeContext, color),
      backgroundColor = _euiButtonFillColor.backgroundColor;
    return _objectSpread(_objectSpread({}, acc), {}, _defineProperty({}, color, /*#__PURE__*/(0, _react.css)("&:focus-visible{", (0, _global_styling.euiOutline)(euiThemeContext, 'center', backgroundColor), " &:is(.euiButtonGroupButton-isSelected){outline-offset:0;}}")));
  }, {});
};
exports._compressedButtonFocusColors = _compressedButtonFocusColors;