"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiButtonEmptyStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../../global_styling");
var _button_display = require("../button_display/_button_display.styles");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
                                                                                                                                                                                                                                                                                           * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                           * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                           * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                           * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                           * Side Public License, v 1.
                                                                                                                                                                                                                                                                                           */
var _ref = process.env.NODE_ENV === "production" ? {
  name: "1lywbid-flush",
  styles: "padding-inline:0;label:flush;"
} : {
  name: "1lywbid-flush",
  styles: "padding-inline:0;label:flush;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiButtonEmptyStyles = function euiButtonEmptyStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;

  // EuiButtonEmpty uses the same size/font styling as EuiButtonDisplay,
  // but does not share enough of the same colors/props to the point
  // of using the actual component - so we'll reuse its styles instead
  var displayStyles = (0, _button_display.euiButtonDisplayStyles)(euiThemeContext);
  return {
    euiButtonEmpty: /*#__PURE__*/(0, _react.css)(displayStyles.euiButtonDisplay, " ", (0, _global_styling.logicalShorthandCSS)('padding', "0 ".concat(euiTheme.size.s)), _global_styling.euiCanAnimate, "{transition-timing-function:ease-in;transition-duration:", euiTheme.animation.fast, ";};label:euiButtonEmpty;"),
    isDisabled: displayStyles.isDisabled,
    // Sizes
    xs: displayStyles.xs,
    s: displayStyles.s,
    m: displayStyles.m,
    // Flush sides
    flush: _ref,
    left: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('margin-right', euiTheme.size.s), ";;label:left;"),
    right: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('margin-left', euiTheme.size.s), ";;label:right;"),
    both: /*#__PURE__*/(0, _react.css)(";label:both;")
  };
};
exports.euiButtonEmptyStyles = euiButtonEmptyStyles;