"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CollapsedItemActions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _predicate = require("../../services/predicate");
var _context_menu = require("../context_menu");
var _popover = require("../popover");
var _button = require("../button");
var _tool_tip = require("../tool_tip");
var _i18n = require("../i18n");
var _action_types = require("./action_types");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(arr, i) { var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"]; if (null != _i) { var _s, _e, _x, _r, _arr = [], _n = !0, _d = !1; try { if (_x = (_i = _i.call(arr)).next, 0 === i) { if (Object(_i) !== _i) return; _n = !1; } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0); } catch (err) { _d = !0, _e = err; } finally { try { if (!_n && null != _i.return && (_r = _i.return(), Object(_r) !== _r)) return; } finally { if (_d) throw _e; } } return _arr; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; } /*
                                                                       * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                       * or more contributor license agreements. Licensed under the Elastic License
                                                                       * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                       * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                       * Side Public License, v 1.
                                                                       */
var CollapsedItemActions = function CollapsedItemActions(_ref) {
  var actions = _ref.actions,
    itemId = _ref.itemId,
    item = _ref.item,
    actionsDisabled = _ref.actionsDisabled,
    className = _ref.className;
  var _useState = (0, _react.useState)(false),
    _useState2 = _slicedToArray(_useState, 2),
    popoverOpen = _useState2[0],
    setPopoverOpen = _useState2[1];
  var onClickItem = (0, _react.useCallback)(function (onClickAction) {
    setPopoverOpen(false);
    onClickAction === null || onClickAction === void 0 ? void 0 : onClickAction();
  }, []);
  var controls = (0, _react.useMemo)(function () {
    return actions.reduce(function (controls, action, index) {
      var _action$available, _action$available2;
      var available = (_action$available = (_action$available2 = action.available) === null || _action$available2 === void 0 ? void 0 : _action$available2.call(action, item)) !== null && _action$available !== void 0 ? _action$available : true;
      if (!available) return controls;
      var enabled = action.enabled == null || action.enabled(item);
      if ((0, _action_types.isCustomItemAction)(action)) {
        var customAction = action;
        var actionControl = customAction.render(item, enabled);
        controls.push(
        // Do not put the `onClick` on the EuiContextMenuItem itself - otherwise
        // it renders a <button> tag instead of a <div>, and we end up with nested
        // interactive elements
        (0, _react2.jsx)(_context_menu.EuiContextMenuItem, {
          key: index,
          className: "euiBasicTable__collapsedCustomAction"
        }, (0, _react2.jsx)("span", {
          onClick: function onClick() {
            return onClickItem();
          }
        }, actionControl)));
      } else {
        var buttonIcon = action.icon;
        var icon;
        if (buttonIcon) {
          icon = (0, _predicate.isString)(buttonIcon) ? buttonIcon : buttonIcon(item);
        }
        var buttonContent = (0, _action_types.callWithItemIfFunction)(item)(action.name);
        var toolTipContent = (0, _action_types.callWithItemIfFunction)(item)(action.description);
        var href = (0, _action_types.callWithItemIfFunction)(item)(action.href);
        var dataTestSubj = (0, _action_types.callWithItemIfFunction)(item)(action['data-test-subj']);
        var _onClick = action.onClick,
          target = action.target;
        controls.push((0, _react2.jsx)(_context_menu.EuiContextMenuItem, {
          key: index,
          className: "euiBasicTable__collapsedAction",
          disabled: !enabled && !actionsDisabled,
          href: href,
          target: target,
          icon: icon,
          "data-test-subj": dataTestSubj,
          onClick: function onClick() {
            return onClickItem(_onClick ? function () {
              return _onClick(item);
            } : undefined);
          },
          toolTipContent: toolTipContent,
          toolTipProps: {
            delay: 'long'
          }
        }, buttonContent));
      }
      return controls;
    }, []);
  }, [actions, actionsDisabled, item, onClickItem]);
  var popoverButton = (0, _react2.jsx)(_i18n.EuiI18n, {
    tokens: ['euiCollapsedItemActions.allActions', 'euiCollapsedItemActions.allActionsDisabled'],
    defaults: ['All actions', 'Individual item actions are disabled when rows are being selected.']
  }, function (_ref2) {
    var _ref3 = _slicedToArray(_ref2, 2),
      allActions = _ref3[0],
      allActionsDisabled = _ref3[1];
    return (0, _react2.jsx)(_button.EuiButtonIcon, {
      className: className,
      "aria-label": actionsDisabled ? allActionsDisabled : allActions,
      title: actionsDisabled ? allActionsDisabled : undefined,
      iconType: "boxesHorizontal",
      color: "text",
      isDisabled: actionsDisabled,
      onClick: function onClick() {
        return setPopoverOpen(function (isOpen) {
          return !isOpen;
        });
      },
      "data-test-subj": "euiCollapsedItemActionsButton"
    });
  });
  var withTooltip = !actionsDisabled && (0, _react2.jsx)(_i18n.EuiI18n, {
    token: "euiCollapsedItemActions.allActions",
    default: "All actions"
  }, function (allActions) {
    return (0, _react2.jsx)(_tool_tip.EuiToolTip, {
      content: allActions,
      delay: "long"
    }, popoverButton);
  });
  return (0, _react2.jsx)(_popover.EuiPopover, {
    className: className,
    id: "".concat(itemId, "-actions"),
    isOpen: popoverOpen,
    button: withTooltip || popoverButton,
    closePopover: function closePopover() {
      return setPopoverOpen(false);
    },
    panelPaddingSize: "none",
    anchorPosition: "leftCenter"
  }, (0, _react2.jsx)(_context_menu.EuiContextMenuPanel, {
    className: "euiBasicTable__collapsedActions",
    items: controls
  }));
};
exports.CollapsedItemActions = CollapsedItemActions;