"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiAccordionButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../../services");
var _accordion_button = require("./accordion_button.styles");
var _react2 = require("@emotion/react");
var _excluded = ["buttonElement", "buttonProps", "buttonClassName", "buttonContentClassName", "isDisabled", "arrowDisplay", "children"],
  _excluded2 = ["paddingSize"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }
function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
var EuiAccordionButton = function EuiAccordionButton(_ref) {
  var ButtonElement = _ref.buttonElement,
    _buttonProps = _ref.buttonProps,
    buttonClassName = _ref.buttonClassName,
    buttonContentClassName = _ref.buttonContentClassName,
    isDisabled = _ref.isDisabled,
    arrowDisplay = _ref.arrowDisplay,
    children = _ref.children,
    rest = _objectWithoutProperties(_ref, _excluded);
  var _ref2 = _buttonProps || {},
    paddingSize = _ref2.paddingSize,
    buttonProps = _objectWithoutProperties(_ref2, _excluded2);
  var classes = (0, _classnames.default)('euiAccordion__button', buttonClassName, buttonProps.className);
  var buttonContentClasses = (0, _classnames.default)('euiAccordion__buttonContent', buttonContentClassName);
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _accordion_button.euiAccordionButtonStyles)(euiTheme);
  var cssStyles = [styles.euiAccordion__button, isDisabled && styles.disabled].concat(_toConsumableArray(paddingSize ? [styles[paddingSize], arrowDisplay === 'left' && styles.arrowLeft, arrowDisplay === 'right' && styles.arrowRight] : []), [buttonProps.css]);
  var elementIsButton = ButtonElement === 'button';
  return (0, _react2.jsx)(ButtonElement, _extends({}, buttonProps, rest, {
    className: classes,
    css: cssStyles,
    type: elementIsButton ? 'button' : undefined,
    disabled: elementIsButton ? isDisabled : undefined
  }), (0, _react2.jsx)("span", {
    className: buttonContentClasses
  }, children));
};
exports.EuiAccordionButton = EuiAccordionButton;