"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getLegendValue = exports.LegendValue = void 0;
const constants_1 = require("../../../../scales/constants");
const utils_1 = require("../../rendering/utils");
exports.LegendValue = Object.freeze({
    None: 'none',
    LastValue: 'lastValue',
    LastNonNullValue: 'lastNonNullValue',
});
function getLegendValue(series, xDomain, type, valueAccessor) {
    if (xDomain.type === constants_1.ScaleType.Ordinal) {
        return null;
    }
    switch (type) {
        case exports.LegendValue.LastNonNullValue: {
            const last = series.data.findLast((d) => d.x === xDomain.dataDomain[1] && valueAccessor(d) !== null);
            return last ? valueAccessor(last) : null;
        }
        case exports.LegendValue.LastValue:
            const last = series.data.findLast((d) => d.x === xDomain.dataDomain[1]);
            if (last && !(0, utils_1.isDatumFilled)(last)) {
                return valueAccessor(last);
            }
            return null;
        default:
        case exports.LegendValue.None:
            return null;
    }
}
exports.getLegendValue = getLegendValue;
//# sourceMappingURL=get_last_value.js.map